/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.ApplicationProtocol;
import software.amazon.awssdk.services.ecs.model.TransportProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PortMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PortMapping> {
    private static final SdkField<Integer> CONTAINER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("containerPort").getter(PortMapping.getter(PortMapping::containerPort)).setter(PortMapping.setter(Builder::containerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPort").build()}).build();
    private static final SdkField<Integer> HOST_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("hostPort").getter(PortMapping.getter(PortMapping::hostPort)).setter(PortMapping.setter(Builder::hostPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostPort").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(PortMapping.getter(PortMapping::protocolAsString)).setter(PortMapping.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PortMapping.getter(PortMapping::name)).setter(PortMapping.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> APP_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appProtocol").getter(PortMapping.getter(PortMapping::appProtocolAsString)).setter(PortMapping.setter(Builder::appProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appProtocol").build()}).build();
    private static final SdkField<String> CONTAINER_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerPortRange").getter(PortMapping.getter(PortMapping::containerPortRange)).setter(PortMapping.setter(Builder::containerPortRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPortRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_PORT_FIELD, HOST_PORT_FIELD, PROTOCOL_FIELD, NAME_FIELD, APP_PROTOCOL_FIELD, CONTAINER_PORT_RANGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer containerPort;
    private final Integer hostPort;
    private final String protocol;
    private final String name;
    private final String appProtocol;
    private final String containerPortRange;

    private PortMapping(BuilderImpl builder) {
        this.containerPort = builder.containerPort;
        this.hostPort = builder.hostPort;
        this.protocol = builder.protocol;
        this.name = builder.name;
        this.appProtocol = builder.appProtocol;
        this.containerPortRange = builder.containerPortRange;
    }

    public final Integer containerPort() {
        return this.containerPort;
    }

    public final Integer hostPort() {
        return this.hostPort;
    }

    public final TransportProtocol protocol() {
        return TransportProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final String name() {
        return this.name;
    }

    public final ApplicationProtocol appProtocol() {
        return ApplicationProtocol.fromValue(this.appProtocol);
    }

    public final String appProtocolAsString() {
        return this.appProtocol;
    }

    public final String containerPortRange() {
        return this.containerPortRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.appProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPortRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortMapping)) {
            return false;
        }
        PortMapping other = (PortMapping)obj;
        return Objects.equals(this.containerPort(), other.containerPort()) && Objects.equals(this.hostPort(), other.hostPort()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.appProtocolAsString(), other.appProtocolAsString()) && Objects.equals(this.containerPortRange(), other.containerPortRange());
    }

    public final String toString() {
        return ToString.builder((String)"PortMapping").add("ContainerPort", (Object)this.containerPort()).add("HostPort", (Object)this.hostPort()).add("Protocol", (Object)this.protocolAsString()).add("Name", (Object)this.name()).add("AppProtocol", (Object)this.appProtocolAsString()).add("ContainerPortRange", (Object)this.containerPortRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerPort": {
                return Optional.ofNullable(clazz.cast(this.containerPort()));
            }
            case "hostPort": {
                return Optional.ofNullable(clazz.cast(this.hostPort()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "appProtocol": {
                return Optional.ofNullable(clazz.cast(this.appProtocolAsString()));
            }
            case "containerPortRange": {
                return Optional.ofNullable(clazz.cast(this.containerPortRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortMapping, T> g) {
        return obj -> g.apply((PortMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer containerPort;
        private Integer hostPort;
        private String protocol;
        private String name;
        private String appProtocol;
        private String containerPortRange;

        private BuilderImpl() {
        }

        private BuilderImpl(PortMapping model) {
            this.containerPort(model.containerPort);
            this.hostPort(model.hostPort);
            this.protocol(model.protocol);
            this.name(model.name);
            this.appProtocol(model.appProtocol);
            this.containerPortRange(model.containerPortRange);
        }

        public final Integer getContainerPort() {
            return this.containerPort;
        }

        public final void setContainerPort(Integer containerPort) {
            this.containerPort = containerPort;
        }

        @Override
        public final Builder containerPort(Integer containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        public final Integer getHostPort() {
            return this.hostPort;
        }

        public final void setHostPort(Integer hostPort) {
            this.hostPort = hostPort;
        }

        @Override
        public final Builder hostPort(Integer hostPort) {
            this.hostPort = hostPort;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(TransportProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAppProtocol() {
            return this.appProtocol;
        }

        public final void setAppProtocol(String appProtocol) {
            this.appProtocol = appProtocol;
        }

        @Override
        public final Builder appProtocol(String appProtocol) {
            this.appProtocol = appProtocol;
            return this;
        }

        @Override
        public final Builder appProtocol(ApplicationProtocol appProtocol) {
            this.appProtocol(appProtocol == null ? null : appProtocol.toString());
            return this;
        }

        public final String getContainerPortRange() {
            return this.containerPortRange;
        }

        public final void setContainerPortRange(String containerPortRange) {
            this.containerPortRange = containerPortRange;
        }

        @Override
        public final Builder containerPortRange(String containerPortRange) {
            this.containerPortRange = containerPortRange;
            return this;
        }

        public PortMapping build() {
            return new PortMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PortMapping> {
        public Builder containerPort(Integer var1);

        public Builder hostPort(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(TransportProtocol var1);

        public Builder name(String var1);

        public Builder appProtocol(String var1);

        public Builder appProtocol(ApplicationProtocol var1);

        public Builder containerPortRange(String var1);
    }
}

