/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current account setting for a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Setting implements SdkPojo, Serializable, ToCopyableBuilder<Setting.Builder, Setting> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Setting::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(Setting::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalArn").getter(getter(Setting::principalArn)).setter(setter(Builder::principalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD,
            PRINCIPAL_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String value;

    private final String principalArn;

    private Setting(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.principalArn = builder.principalArn;
    }

    /**
     * <p>
     * The Amazon ECS resource name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link SettingName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The Amazon ECS resource name.
     * @see SettingName
     */
    public final SettingName name() {
        return SettingName.fromValue(name);
    }

    /**
     * <p>
     * The Amazon ECS resource name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link SettingName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The Amazon ECS resource name.
     * @see SettingName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * Whether the account setting is enabled or disabled for the specified resource.
     * </p>
     * 
     * @return Whether the account setting is enabled or disabled for the specified resource.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The ARN of the principal, which can be an IAM user, IAM role, or the root user. If this field is omitted, the
     * authenticated user is assumed.
     * </p>
     * 
     * @return The ARN of the principal, which can be an IAM user, IAM role, or the root user. If this field is omitted,
     *         the authenticated user is assumed.
     */
    public final String principalArn() {
        return principalArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(principalArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Setting)) {
            return false;
        }
        Setting other = (Setting) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(value(), other.value())
                && Objects.equals(principalArn(), other.principalArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Setting").add("Name", nameAsString()).add("Value", value()).add("PrincipalArn", principalArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "principalArn":
            return Optional.ofNullable(clazz.cast(principalArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Setting, T> g) {
        return obj -> g.apply((Setting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Setting> {
        /**
         * <p>
         * The Amazon ECS resource name.
         * </p>
         * 
         * @param name
         *        The Amazon ECS resource name.
         * @see SettingName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SettingName
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon ECS resource name.
         * </p>
         * 
         * @param name
         *        The Amazon ECS resource name.
         * @see SettingName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SettingName
         */
        Builder name(SettingName name);

        /**
         * <p>
         * Whether the account setting is enabled or disabled for the specified resource.
         * </p>
         * 
         * @param value
         *        Whether the account setting is enabled or disabled for the specified resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The ARN of the principal, which can be an IAM user, IAM role, or the root user. If this field is omitted, the
         * authenticated user is assumed.
         * </p>
         * 
         * @param principalArn
         *        The ARN of the principal, which can be an IAM user, IAM role, or the root user. If this field is
         *        omitted, the authenticated user is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private String principalArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Setting model) {
            name(model.name);
            value(model.value);
            principalArn(model.principalArn);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(SettingName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public Setting build() {
            return new Setting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
