/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutClusterCapacityProvidersRequest extends EcsRequest implements
        ToCopyableBuilder<PutClusterCapacityProvidersRequest.Builder, PutClusterCapacityProvidersRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(PutClusterCapacityProvidersRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<List<String>> CAPACITY_PROVIDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("capacityProviders")
            .getter(getter(PutClusterCapacityProvidersRequest::capacityProviders))
            .setter(setter(Builder::capacityProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CapacityProviderStrategyItem>> DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField
            .<List<CapacityProviderStrategyItem>> builder(MarshallingType.LIST)
            .memberName("defaultCapacityProviderStrategy")
            .getter(getter(PutClusterCapacityProvidersRequest::defaultCapacityProviderStrategy))
            .setter(setter(Builder::defaultCapacityProviderStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultCapacityProviderStrategy")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapacityProviderStrategyItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityProviderStrategyItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD,
            CAPACITY_PROVIDERS_FIELD, DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD));

    private final String cluster;

    private final List<String> capacityProviders;

    private final List<CapacityProviderStrategyItem> defaultCapacityProviderStrategy;

    private PutClusterCapacityProvidersRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.capacityProviders = builder.capacityProviders;
        this.defaultCapacityProviderStrategy = builder.defaultCapacityProviderStrategy;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster to modify the capacity provider settings for. If
     * you do not specify a cluster, the default cluster is assumed.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster to modify the capacity provider settings
     *         for. If you do not specify a cluster, the default cluster is assumed.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * Returns true if the CapacityProviders property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCapacityProviders() {
        return capacityProviders != null && !(capacityProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of one or more capacity providers to associate with the cluster.
     * </p>
     * <p>
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created.
     * New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
     * </p>
     * <p>
     * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
     * capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be
     * associated with a cluster to be used.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCapacityProviders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of one or more capacity providers to associate with the cluster.</p>
     *         <p>
     *         If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
     *         created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
     *         </p>
     *         <p>
     *         To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or
     *         <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all
     *         accounts and only need to be associated with a cluster to be used.
     */
    public final List<String> capacityProviders() {
        return capacityProviders;
    }

    /**
     * Returns true if the DefaultCapacityProviderStrategy property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasDefaultCapacityProviderStrategy() {
        return defaultCapacityProviderStrategy != null && !(defaultCapacityProviderStrategy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capacity provider strategy to use by default for the cluster.
     * </p>
     * <p>
     * When creating a service or running a task on a cluster, if no capacity provider or launch type is specified then
     * the default capacity provider strategy for the cluster is used.
     * </p>
     * <p>
     * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and
     * <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a
     * capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a capacity provider
     * with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
     * </p>
     * <p>
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created.
     * New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
     * </p>
     * <p>
     * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
     * capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be
     * associated with a cluster to be used.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDefaultCapacityProviderStrategy()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The capacity provider strategy to use by default for the cluster.</p>
     *         <p>
     *         When creating a service or running a task on a cluster, if no capacity provider or launch type is
     *         specified then the default capacity provider strategy for the cluster is used.
     *         </p>
     *         <p>
     *         A capacity provider strategy consists of one or more capacity providers along with the <code>base</code>
     *         and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be
     *         used in a capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a
     *         capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or
     *         <code>UPDATING</code> status can be used.
     *         </p>
     *         <p>
     *         If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
     *         created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
     *         </p>
     *         <p>
     *         To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or
     *         <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all
     *         accounts and only need to be associated with a cluster to be used.
     */
    public final List<CapacityProviderStrategyItem> defaultCapacityProviderStrategy() {
        return defaultCapacityProviderStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityProviders() ? capacityProviders() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDefaultCapacityProviderStrategy() ? defaultCapacityProviderStrategy() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutClusterCapacityProvidersRequest)) {
            return false;
        }
        PutClusterCapacityProvidersRequest other = (PutClusterCapacityProvidersRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && hasCapacityProviders() == other.hasCapacityProviders()
                && Objects.equals(capacityProviders(), other.capacityProviders())
                && hasDefaultCapacityProviderStrategy() == other.hasDefaultCapacityProviderStrategy()
                && Objects.equals(defaultCapacityProviderStrategy(), other.defaultCapacityProviderStrategy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("PutClusterCapacityProvidersRequest")
                .add("Cluster", cluster())
                .add("CapacityProviders", hasCapacityProviders() ? capacityProviders() : null)
                .add("DefaultCapacityProviderStrategy",
                        hasDefaultCapacityProviderStrategy() ? defaultCapacityProviderStrategy() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "capacityProviders":
            return Optional.ofNullable(clazz.cast(capacityProviders()));
        case "defaultCapacityProviderStrategy":
            return Optional.ofNullable(clazz.cast(defaultCapacityProviderStrategy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutClusterCapacityProvidersRequest, T> g) {
        return obj -> g.apply((PutClusterCapacityProvidersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutClusterCapacityProvidersRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster to modify the capacity provider settings
         * for. If you do not specify a cluster, the default cluster is assumed.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster to modify the capacity provider
         *        settings for. If you do not specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The name of one or more capacity providers to associate with the cluster.
         * </p>
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
         * created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
         * </p>
         * <p>
         * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
         * capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be
         * associated with a cluster to be used.
         * </p>
         * 
         * @param capacityProviders
         *        The name of one or more capacity providers to associate with the cluster.</p>
         *        <p>
         *        If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already
         *        be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API
         *        operation.
         *        </p>
         *        <p>
         *        To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or
         *        <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all
         *        accounts and only need to be associated with a cluster to be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviders(Collection<String> capacityProviders);

        /**
         * <p>
         * The name of one or more capacity providers to associate with the cluster.
         * </p>
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
         * created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
         * </p>
         * <p>
         * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
         * capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be
         * associated with a cluster to be used.
         * </p>
         * 
         * @param capacityProviders
         *        The name of one or more capacity providers to associate with the cluster.</p>
         *        <p>
         *        If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already
         *        be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API
         *        operation.
         *        </p>
         *        <p>
         *        To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or
         *        <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all
         *        accounts and only need to be associated with a cluster to be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviders(String... capacityProviders);

        /**
         * <p>
         * The capacity provider strategy to use by default for the cluster.
         * </p>
         * <p>
         * When creating a service or running a task on a cluster, if no capacity provider or launch type is specified
         * then the default capacity provider strategy for the cluster is used.
         * </p>
         * <p>
         * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and
         * <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in
         * a capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a capacity
         * provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status
         * can be used.
         * </p>
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
         * created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
         * </p>
         * <p>
         * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
         * capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be
         * associated with a cluster to be used.
         * </p>
         * 
         * @param defaultCapacityProviderStrategy
         *        The capacity provider strategy to use by default for the cluster.</p>
         *        <p>
         *        When creating a service or running a task on a cluster, if no capacity provider or launch type is
         *        specified then the default capacity provider strategy for the cluster is used.
         *        </p>
         *        <p>
         *        A capacity provider strategy consists of one or more capacity providers along with the
         *        <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated
         *        with the cluster to be used in a capacity provider strategy. The <a>PutClusterCapacityProviders</a>
         *        API is used to associate a capacity provider with a cluster. Only capacity providers with an
         *        <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
         *        </p>
         *        <p>
         *        If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already
         *        be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API
         *        operation.
         *        </p>
         *        <p>
         *        To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or
         *        <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all
         *        accounts and only need to be associated with a cluster to be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCapacityProviderStrategy(Collection<CapacityProviderStrategyItem> defaultCapacityProviderStrategy);

        /**
         * <p>
         * The capacity provider strategy to use by default for the cluster.
         * </p>
         * <p>
         * When creating a service or running a task on a cluster, if no capacity provider or launch type is specified
         * then the default capacity provider strategy for the cluster is used.
         * </p>
         * <p>
         * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and
         * <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in
         * a capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a capacity
         * provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status
         * can be used.
         * </p>
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
         * created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
         * </p>
         * <p>
         * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
         * capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be
         * associated with a cluster to be used.
         * </p>
         * 
         * @param defaultCapacityProviderStrategy
         *        The capacity provider strategy to use by default for the cluster.</p>
         *        <p>
         *        When creating a service or running a task on a cluster, if no capacity provider or launch type is
         *        specified then the default capacity provider strategy for the cluster is used.
         *        </p>
         *        <p>
         *        A capacity provider strategy consists of one or more capacity providers along with the
         *        <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated
         *        with the cluster to be used in a capacity provider strategy. The <a>PutClusterCapacityProviders</a>
         *        API is used to associate a capacity provider with a cluster. Only capacity providers with an
         *        <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
         *        </p>
         *        <p>
         *        If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already
         *        be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API
         *        operation.
         *        </p>
         *        <p>
         *        To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or
         *        <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all
         *        accounts and only need to be associated with a cluster to be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCapacityProviderStrategy(CapacityProviderStrategyItem... defaultCapacityProviderStrategy);

        /**
         * <p>
         * The capacity provider strategy to use by default for the cluster.
         * </p>
         * <p>
         * When creating a service or running a task on a cluster, if no capacity provider or launch type is specified
         * then the default capacity provider strategy for the cluster is used.
         * </p>
         * <p>
         * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and
         * <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in
         * a capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a capacity
         * provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status
         * can be used.
         * </p>
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
         * created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
         * </p>
         * <p>
         * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
         * capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be
         * associated with a cluster to be used.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CapacityProviderStrategyItem>.Builder}
         * avoiding the need to create one manually via {@link List<CapacityProviderStrategyItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CapacityProviderStrategyItem>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #defaultCapacityProviderStrategy(List<CapacityProviderStrategyItem>)}.
         * 
         * @param defaultCapacityProviderStrategy
         *        a consumer that will call methods on {@link List<CapacityProviderStrategyItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultCapacityProviderStrategy(List<CapacityProviderStrategyItem>)
         */
        Builder defaultCapacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder>... defaultCapacityProviderStrategy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private List<String> capacityProviders = DefaultSdkAutoConstructList.getInstance();

        private List<CapacityProviderStrategyItem> defaultCapacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutClusterCapacityProvidersRequest model) {
            super(model);
            cluster(model.cluster);
            capacityProviders(model.capacityProviders);
            defaultCapacityProviderStrategy(model.defaultCapacityProviderStrategy);
        }

        public final String getCluster() {
            return cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final Collection<String> getCapacityProviders() {
            if (capacityProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return capacityProviders;
        }

        @Override
        public final Builder capacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = StringListCopier.copy(capacityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviders(String... capacityProviders) {
            capacityProviders(Arrays.asList(capacityProviders));
            return this;
        }

        public final void setCapacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = StringListCopier.copy(capacityProviders);
        }

        public final Collection<CapacityProviderStrategyItem.Builder> getDefaultCapacityProviderStrategy() {
            if (defaultCapacityProviderStrategy instanceof SdkAutoConstructList) {
                return null;
            }
            return defaultCapacityProviderStrategy != null ? defaultCapacityProviderStrategy.stream()
                    .map(CapacityProviderStrategyItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder defaultCapacityProviderStrategy(
                Collection<CapacityProviderStrategyItem> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = CapacityProviderStrategyCopier.copy(defaultCapacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultCapacityProviderStrategy(CapacityProviderStrategyItem... defaultCapacityProviderStrategy) {
            defaultCapacityProviderStrategy(Arrays.asList(defaultCapacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultCapacityProviderStrategy(
                Consumer<CapacityProviderStrategyItem.Builder>... defaultCapacityProviderStrategy) {
            defaultCapacityProviderStrategy(Stream.of(defaultCapacityProviderStrategy)
                    .map(c -> CapacityProviderStrategyItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDefaultCapacityProviderStrategy(
                Collection<CapacityProviderStrategyItem.BuilderImpl> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = CapacityProviderStrategyCopier
                    .copyFromBuilder(defaultCapacityProviderStrategy);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutClusterCapacityProvidersRequest build() {
            return new PutClusterCapacityProvidersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
