/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.Attribute;
import software.amazon.awssdk.services.ecs.model.AttributesCopier;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.PlatformDevice;
import software.amazon.awssdk.services.ecs.model.PlatformDevicesCopier;
import software.amazon.awssdk.services.ecs.model.Resource;
import software.amazon.awssdk.services.ecs.model.ResourcesCopier;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.services.ecs.model.VersionInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterContainerInstanceRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, RegisterContainerInstanceRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterContainerInstanceRequest.getter(RegisterContainerInstanceRequest::cluster)).setter(RegisterContainerInstanceRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> INSTANCE_IDENTITY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterContainerInstanceRequest.getter(RegisterContainerInstanceRequest::instanceIdentityDocument)).setter(RegisterContainerInstanceRequest.setter(Builder::instanceIdentityDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceIdentityDocument").build()}).build();
    private static final SdkField<String> INSTANCE_IDENTITY_DOCUMENT_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterContainerInstanceRequest.getter(RegisterContainerInstanceRequest::instanceIdentityDocumentSignature)).setter(RegisterContainerInstanceRequest.setter(Builder::instanceIdentityDocumentSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceIdentityDocumentSignature").build()}).build();
    private static final SdkField<List<Resource>> TOTAL_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RegisterContainerInstanceRequest.getter(RegisterContainerInstanceRequest::totalResources)).setter(RegisterContainerInstanceRequest.setter(Builder::totalResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VersionInfo> VERSION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RegisterContainerInstanceRequest.getter(RegisterContainerInstanceRequest::versionInfo)).setter(RegisterContainerInstanceRequest.setter(Builder::versionInfo)).constructor(VersionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionInfo").build()}).build();
    private static final SdkField<String> CONTAINER_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterContainerInstanceRequest.getter(RegisterContainerInstanceRequest::containerInstanceArn)).setter(RegisterContainerInstanceRequest.setter(Builder::containerInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstanceArn").build()}).build();
    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RegisterContainerInstanceRequest.getter(RegisterContainerInstanceRequest::attributes)).setter(RegisterContainerInstanceRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PlatformDevice>> PLATFORM_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RegisterContainerInstanceRequest.getter(RegisterContainerInstanceRequest::platformDevices)).setter(RegisterContainerInstanceRequest.setter(Builder::platformDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformDevices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlatformDevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RegisterContainerInstanceRequest.getter(RegisterContainerInstanceRequest::tags)).setter(RegisterContainerInstanceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, INSTANCE_IDENTITY_DOCUMENT_FIELD, INSTANCE_IDENTITY_DOCUMENT_SIGNATURE_FIELD, TOTAL_RESOURCES_FIELD, VERSION_INFO_FIELD, CONTAINER_INSTANCE_ARN_FIELD, ATTRIBUTES_FIELD, PLATFORM_DEVICES_FIELD, TAGS_FIELD));
    private final String cluster;
    private final String instanceIdentityDocument;
    private final String instanceIdentityDocumentSignature;
    private final List<Resource> totalResources;
    private final VersionInfo versionInfo;
    private final String containerInstanceArn;
    private final List<Attribute> attributes;
    private final List<PlatformDevice> platformDevices;
    private final List<Tag> tags;

    private RegisterContainerInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.instanceIdentityDocument = builder.instanceIdentityDocument;
        this.instanceIdentityDocumentSignature = builder.instanceIdentityDocumentSignature;
        this.totalResources = builder.totalResources;
        this.versionInfo = builder.versionInfo;
        this.containerInstanceArn = builder.containerInstanceArn;
        this.attributes = builder.attributes;
        this.platformDevices = builder.platformDevices;
        this.tags = builder.tags;
    }

    public String cluster() {
        return this.cluster;
    }

    public String instanceIdentityDocument() {
        return this.instanceIdentityDocument;
    }

    public String instanceIdentityDocumentSignature() {
        return this.instanceIdentityDocumentSignature;
    }

    public boolean hasTotalResources() {
        return this.totalResources != null && !(this.totalResources instanceof SdkAutoConstructList);
    }

    public List<Resource> totalResources() {
        return this.totalResources;
    }

    public VersionInfo versionInfo() {
        return this.versionInfo;
    }

    public String containerInstanceArn() {
        return this.containerInstanceArn;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public List<Attribute> attributes() {
        return this.attributes;
    }

    public boolean hasPlatformDevices() {
        return this.platformDevices != null && !(this.platformDevices instanceof SdkAutoConstructList);
    }

    public List<PlatformDevice> platformDevices() {
        return this.platformDevices;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceIdentityDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceIdentityDocumentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformDevices());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterContainerInstanceRequest)) {
            return false;
        }
        RegisterContainerInstanceRequest other = (RegisterContainerInstanceRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.instanceIdentityDocument(), other.instanceIdentityDocument()) && Objects.equals(this.instanceIdentityDocumentSignature(), other.instanceIdentityDocumentSignature()) && Objects.equals(this.totalResources(), other.totalResources()) && Objects.equals(this.versionInfo(), other.versionInfo()) && Objects.equals(this.containerInstanceArn(), other.containerInstanceArn()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.platformDevices(), other.platformDevices()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"RegisterContainerInstanceRequest").add("Cluster", (Object)this.cluster()).add("InstanceIdentityDocument", (Object)this.instanceIdentityDocument()).add("InstanceIdentityDocumentSignature", (Object)this.instanceIdentityDocumentSignature()).add("TotalResources", this.totalResources()).add("VersionInfo", (Object)this.versionInfo()).add("ContainerInstanceArn", (Object)this.containerInstanceArn()).add("Attributes", this.attributes()).add("PlatformDevices", this.platformDevices()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "instanceIdentityDocument": {
                return Optional.ofNullable(clazz.cast(this.instanceIdentityDocument()));
            }
            case "instanceIdentityDocumentSignature": {
                return Optional.ofNullable(clazz.cast(this.instanceIdentityDocumentSignature()));
            }
            case "totalResources": {
                return Optional.ofNullable(clazz.cast(this.totalResources()));
            }
            case "versionInfo": {
                return Optional.ofNullable(clazz.cast(this.versionInfo()));
            }
            case "containerInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.containerInstanceArn()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "platformDevices": {
                return Optional.ofNullable(clazz.cast(this.platformDevices()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterContainerInstanceRequest, T> g) {
        return obj -> g.apply((RegisterContainerInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private String instanceIdentityDocument;
        private String instanceIdentityDocumentSignature;
        private List<Resource> totalResources = DefaultSdkAutoConstructList.getInstance();
        private VersionInfo versionInfo;
        private String containerInstanceArn;
        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();
        private List<PlatformDevice> platformDevices = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterContainerInstanceRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.instanceIdentityDocument(model.instanceIdentityDocument);
            this.instanceIdentityDocumentSignature(model.instanceIdentityDocumentSignature);
            this.totalResources(model.totalResources);
            this.versionInfo(model.versionInfo);
            this.containerInstanceArn(model.containerInstanceArn);
            this.attributes(model.attributes);
            this.platformDevices(model.platformDevices);
            this.tags(model.tags);
        }

        public final String getCluster() {
            return this.cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getInstanceIdentityDocument() {
            return this.instanceIdentityDocument;
        }

        @Override
        public final Builder instanceIdentityDocument(String instanceIdentityDocument) {
            this.instanceIdentityDocument = instanceIdentityDocument;
            return this;
        }

        public final void setInstanceIdentityDocument(String instanceIdentityDocument) {
            this.instanceIdentityDocument = instanceIdentityDocument;
        }

        public final String getInstanceIdentityDocumentSignature() {
            return this.instanceIdentityDocumentSignature;
        }

        @Override
        public final Builder instanceIdentityDocumentSignature(String instanceIdentityDocumentSignature) {
            this.instanceIdentityDocumentSignature = instanceIdentityDocumentSignature;
            return this;
        }

        public final void setInstanceIdentityDocumentSignature(String instanceIdentityDocumentSignature) {
            this.instanceIdentityDocumentSignature = instanceIdentityDocumentSignature;
        }

        public final Collection<Resource.Builder> getTotalResources() {
            return this.totalResources != null ? (Collection)this.totalResources.stream().map(Resource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder totalResources(Collection<Resource> totalResources) {
            this.totalResources = ResourcesCopier.copy(totalResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder totalResources(Resource ... totalResources) {
            this.totalResources(Arrays.asList(totalResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder totalResources(Consumer<Resource.Builder> ... totalResources) {
            this.totalResources(Stream.of(totalResources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTotalResources(Collection<Resource.BuilderImpl> totalResources) {
            this.totalResources = ResourcesCopier.copyFromBuilder(totalResources);
        }

        public final VersionInfo.Builder getVersionInfo() {
            return this.versionInfo != null ? this.versionInfo.toBuilder() : null;
        }

        @Override
        public final Builder versionInfo(VersionInfo versionInfo) {
            this.versionInfo = versionInfo;
            return this;
        }

        public final void setVersionInfo(VersionInfo.BuilderImpl versionInfo) {
            this.versionInfo = versionInfo != null ? versionInfo.build() : null;
        }

        public final String getContainerInstanceArn() {
            return this.containerInstanceArn;
        }

        @Override
        public final Builder containerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
            return this;
        }

        public final void setContainerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
        }

        public final Collection<Attribute.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(Attribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributesCopier.copyFromBuilder(attributes);
        }

        public final Collection<PlatformDevice.Builder> getPlatformDevices() {
            return this.platformDevices != null ? (Collection)this.platformDevices.stream().map(PlatformDevice::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder platformDevices(Collection<PlatformDevice> platformDevices) {
            this.platformDevices = PlatformDevicesCopier.copy(platformDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformDevices(PlatformDevice ... platformDevices) {
            this.platformDevices(Arrays.asList(platformDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformDevices(Consumer<PlatformDevice.Builder> ... platformDevices) {
            this.platformDevices(Stream.of(platformDevices).map(c -> (PlatformDevice)((PlatformDevice.Builder)PlatformDevice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlatformDevices(Collection<PlatformDevice.BuilderImpl> platformDevices) {
            this.platformDevices = PlatformDevicesCopier.copyFromBuilder(platformDevices);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterContainerInstanceRequest build() {
            return new RegisterContainerInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterContainerInstanceRequest> {
        public Builder cluster(String var1);

        public Builder instanceIdentityDocument(String var1);

        public Builder instanceIdentityDocumentSignature(String var1);

        public Builder totalResources(Collection<Resource> var1);

        public Builder totalResources(Resource ... var1);

        public Builder totalResources(Consumer<Resource.Builder> ... var1);

        public Builder versionInfo(VersionInfo var1);

        default public Builder versionInfo(Consumer<VersionInfo.Builder> versionInfo) {
            return this.versionInfo((VersionInfo)((VersionInfo.Builder)VersionInfo.builder().applyMutation(versionInfo)).build());
        }

        public Builder containerInstanceArn(String var1);

        public Builder attributes(Collection<Attribute> var1);

        public Builder attributes(Attribute ... var1);

        public Builder attributes(Consumer<Attribute.Builder> ... var1);

        public Builder platformDevices(Collection<PlatformDevice> var1);

        public Builder platformDevices(PlatformDevice ... var1);

        public Builder platformDevices(Consumer<PlatformDevice.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

