/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.TransitioningImageTotalCount;
import software.amazon.awssdk.services.ecr.model.TransitioningImageTotalCountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecyclePolicyPreviewSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecyclePolicyPreviewSummary> {
    private static final SdkField<Integer> EXPIRING_IMAGE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("expiringImageTotalCount").getter(LifecyclePolicyPreviewSummary.getter(LifecyclePolicyPreviewSummary::expiringImageTotalCount)).setter(LifecyclePolicyPreviewSummary.setter(Builder::expiringImageTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiringImageTotalCount").build()}).build();
    private static final SdkField<List<TransitioningImageTotalCount>> TRANSITIONING_IMAGE_TOTAL_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("transitioningImageTotalCounts").getter(LifecyclePolicyPreviewSummary.getter(LifecyclePolicyPreviewSummary::transitioningImageTotalCounts)).setter(LifecyclePolicyPreviewSummary.setter(Builder::transitioningImageTotalCounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitioningImageTotalCounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitioningImageTotalCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRING_IMAGE_TOTAL_COUNT_FIELD, TRANSITIONING_IMAGE_TOTAL_COUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LifecyclePolicyPreviewSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer expiringImageTotalCount;
    private final List<TransitioningImageTotalCount> transitioningImageTotalCounts;

    private LifecyclePolicyPreviewSummary(BuilderImpl builder) {
        this.expiringImageTotalCount = builder.expiringImageTotalCount;
        this.transitioningImageTotalCounts = builder.transitioningImageTotalCounts;
    }

    public final Integer expiringImageTotalCount() {
        return this.expiringImageTotalCount;
    }

    public final boolean hasTransitioningImageTotalCounts() {
        return this.transitioningImageTotalCounts != null && !(this.transitioningImageTotalCounts instanceof SdkAutoConstructList);
    }

    public final List<TransitioningImageTotalCount> transitioningImageTotalCounts() {
        return this.transitioningImageTotalCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expiringImageTotalCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitioningImageTotalCounts() ? this.transitioningImageTotalCounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyPreviewSummary)) {
            return false;
        }
        LifecyclePolicyPreviewSummary other = (LifecyclePolicyPreviewSummary)obj;
        return Objects.equals(this.expiringImageTotalCount(), other.expiringImageTotalCount()) && this.hasTransitioningImageTotalCounts() == other.hasTransitioningImageTotalCounts() && Objects.equals(this.transitioningImageTotalCounts(), other.transitioningImageTotalCounts());
    }

    public final String toString() {
        return ToString.builder((String)"LifecyclePolicyPreviewSummary").add("ExpiringImageTotalCount", (Object)this.expiringImageTotalCount()).add("TransitioningImageTotalCounts", this.hasTransitioningImageTotalCounts() ? this.transitioningImageTotalCounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "expiringImageTotalCount": {
                return Optional.ofNullable(clazz.cast(this.expiringImageTotalCount()));
            }
            case "transitioningImageTotalCounts": {
                return Optional.ofNullable(clazz.cast(this.transitioningImageTotalCounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("expiringImageTotalCount", EXPIRING_IMAGE_TOTAL_COUNT_FIELD);
        map.put("transitioningImageTotalCounts", TRANSITIONING_IMAGE_TOTAL_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyPreviewSummary, T> g) {
        return obj -> g.apply((LifecyclePolicyPreviewSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer expiringImageTotalCount;
        private List<TransitioningImageTotalCount> transitioningImageTotalCounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyPreviewSummary model) {
            this.expiringImageTotalCount(model.expiringImageTotalCount);
            this.transitioningImageTotalCounts(model.transitioningImageTotalCounts);
        }

        public final Integer getExpiringImageTotalCount() {
            return this.expiringImageTotalCount;
        }

        public final void setExpiringImageTotalCount(Integer expiringImageTotalCount) {
            this.expiringImageTotalCount = expiringImageTotalCount;
        }

        @Override
        public final Builder expiringImageTotalCount(Integer expiringImageTotalCount) {
            this.expiringImageTotalCount = expiringImageTotalCount;
            return this;
        }

        public final List<TransitioningImageTotalCount.Builder> getTransitioningImageTotalCounts() {
            List<TransitioningImageTotalCount.Builder> result = TransitioningImageTotalCountsCopier.copyToBuilder(this.transitioningImageTotalCounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitioningImageTotalCounts(Collection<TransitioningImageTotalCount.BuilderImpl> transitioningImageTotalCounts) {
            this.transitioningImageTotalCounts = TransitioningImageTotalCountsCopier.copyFromBuilder(transitioningImageTotalCounts);
        }

        @Override
        public final Builder transitioningImageTotalCounts(Collection<TransitioningImageTotalCount> transitioningImageTotalCounts) {
            this.transitioningImageTotalCounts = TransitioningImageTotalCountsCopier.copy(transitioningImageTotalCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitioningImageTotalCounts(TransitioningImageTotalCount ... transitioningImageTotalCounts) {
            this.transitioningImageTotalCounts(Arrays.asList(transitioningImageTotalCounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitioningImageTotalCounts(Consumer<TransitioningImageTotalCount.Builder> ... transitioningImageTotalCounts) {
            this.transitioningImageTotalCounts(Stream.of(transitioningImageTotalCounts).map(c -> (TransitioningImageTotalCount)((TransitioningImageTotalCount.Builder)TransitioningImageTotalCount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LifecyclePolicyPreviewSummary build() {
            return new LifecyclePolicyPreviewSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecyclePolicyPreviewSummary> {
        public Builder expiringImageTotalCount(Integer var1);

        public Builder transitioningImageTotalCounts(Collection<TransitioningImageTotalCount> var1);

        public Builder transitioningImageTotalCounts(TransitioningImageTotalCount ... var1);

        public Builder transitioningImageTotalCounts(Consumer<TransitioningImageTotalCount.Builder> ... var1);
    }
}

