/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <fullname>Amazon Elastic Container Registry</fullname>
 * <p>
 * Amazon Elastic Container Registry (Amazon ECR) is a managed container image registry service. Customers can use the
 * familiar Docker CLI, or their preferred client, to push, pull, and manage images. Amazon ECR provides a secure,
 * scalable, and reliable registry for your Docker or Open Container Initiative (OCI) images. Amazon ECR supports
 * private repositories with resource-based permissions using IAM so that specific users or Amazon EC2 instances can
 * access repositories and images.
 * </p>
 * <p>
 * Amazon ECR has service endpoints in each supported Region. For more information, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/ecr.html">Amazon ECR endpoints</a> in the <i>Amazon Web Services
 * General Reference</i>.
 * </p>
 *
 * <h2>Code Examples</h2>
 * <p>
 * For code examples demonstrating how to use this service with the AWS SDK for Java v2, see:
 * </p>
 * <h3>Getting Started</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ecr_example_ecr_Hello_section.html"
 * target="_top">Hello Amazon ECR</a></li>
 * </ul>
 * <h3>Basics</h3>
 * <ul>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/ecr_example_ecr_Scenario_RepositoryManagement_section.html"
 * target="_top">Learn the basics of Amazon ECR with an AWS SDK</a></li>
 * </ul>
 * <h3>API Actions</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ecr_example_ecr_PushImageCmd_section.html"
 * target="_top">Use PushImageCmd</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ecr_example_ecr_SetRepositoryPolicy_section.html"
 * target="_top">Use SetRepositoryPolicy</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ecr_example_ecr_GetRepositoryPolicy_section.html"
 * target="_top">Use GetRepositoryPolicy</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ecr_example_ecr_GetAuthorizationToken_section.html"
 * target="_top">Use GetAuthorizationToken</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/ecr_example_ecr_StartLifecyclePolicyPreview_section.html"
 * target="_top">Use StartLifecyclePolicyPreview</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ecr_example_ecr_DescribeImages_section.html"
 * target="_top">Use DescribeImages</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ecr_example_ecr_DeleteRepository_section.html"
 * target="_top">Use DeleteRepository</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ecr_example_ecr_CreateRepository_section.html"
 * target="_top">Use CreateRepository</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ecr_example_ecr_DescribeRepositories_section.html"
 * target="_top">Use DescribeRepositories</a></li>
 * </ul>
 */
package software.amazon.awssdk.services.ecr;