/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAuthorizationTokenResponse extends EcrResponse implements
        ToCopyableBuilder<GetAuthorizationTokenResponse.Builder, GetAuthorizationTokenResponse> {
    private static final SdkField<List<AuthorizationData>> AUTHORIZATION_DATA_FIELD = SdkField
            .<List<AuthorizationData>> builder(MarshallingType.LIST)
            .memberName("authorizationData")
            .getter(getter(GetAuthorizationTokenResponse::authorizationData))
            .setter(setter(Builder::authorizationData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthorizationData> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthorizationData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AuthorizationData> authorizationData;

    private GetAuthorizationTokenResponse(BuilderImpl builder) {
        super(builder);
        this.authorizationData = builder.authorizationData;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizationData property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthorizationData() {
        return authorizationData != null && !(authorizationData instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of authorization token data objects that correspond to the <code>registryIds</code> values in the request.
     * </p>
     * <note>
     * <p>
     * The size of the authorization token returned by Amazon ECR is not fixed. We recommend that you don't make
     * assumptions about the maximum size.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizationData} method.
     * </p>
     * 
     * @return A list of authorization token data objects that correspond to the <code>registryIds</code> values in the
     *         request.</p> <note>
     *         <p>
     *         The size of the authorization token returned by Amazon ECR is not fixed. We recommend that you don't make
     *         assumptions about the maximum size.
     *         </p>
     */
    public final List<AuthorizationData> authorizationData() {
        return authorizationData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizationData() ? authorizationData() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAuthorizationTokenResponse)) {
            return false;
        }
        GetAuthorizationTokenResponse other = (GetAuthorizationTokenResponse) obj;
        return hasAuthorizationData() == other.hasAuthorizationData()
                && Objects.equals(authorizationData(), other.authorizationData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAuthorizationTokenResponse")
                .add("AuthorizationData", hasAuthorizationData() ? authorizationData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizationData":
            return Optional.ofNullable(clazz.cast(authorizationData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authorizationData", AUTHORIZATION_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAuthorizationTokenResponse, T> g) {
        return obj -> g.apply((GetAuthorizationTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAuthorizationTokenResponse> {
        /**
         * <p>
         * A list of authorization token data objects that correspond to the <code>registryIds</code> values in the
         * request.
         * </p>
         * <note>
         * <p>
         * The size of the authorization token returned by Amazon ECR is not fixed. We recommend that you don't make
         * assumptions about the maximum size.
         * </p>
         * </note>
         * 
         * @param authorizationData
         *        A list of authorization token data objects that correspond to the <code>registryIds</code> values in
         *        the request.</p> <note>
         *        <p>
         *        The size of the authorization token returned by Amazon ECR is not fixed. We recommend that you don't
         *        make assumptions about the maximum size.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationData(Collection<AuthorizationData> authorizationData);

        /**
         * <p>
         * A list of authorization token data objects that correspond to the <code>registryIds</code> values in the
         * request.
         * </p>
         * <note>
         * <p>
         * The size of the authorization token returned by Amazon ECR is not fixed. We recommend that you don't make
         * assumptions about the maximum size.
         * </p>
         * </note>
         * 
         * @param authorizationData
         *        A list of authorization token data objects that correspond to the <code>registryIds</code> values in
         *        the request.</p> <note>
         *        <p>
         *        The size of the authorization token returned by Amazon ECR is not fixed. We recommend that you don't
         *        make assumptions about the maximum size.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationData(AuthorizationData... authorizationData);

        /**
         * <p>
         * A list of authorization token data objects that correspond to the <code>registryIds</code> values in the
         * request.
         * </p>
         * <note>
         * <p>
         * The size of the authorization token returned by Amazon ECR is not fixed. We recommend that you don't make
         * assumptions about the maximum size.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.AuthorizationData.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecr.model.AuthorizationData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecr.model.AuthorizationData.Builder#build()} is called immediately and
         * its result is passed to {@link #authorizationData(List<AuthorizationData>)}.
         * 
         * @param authorizationData
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecr.model.AuthorizationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizationData(java.util.Collection<AuthorizationData>)
         */
        Builder authorizationData(Consumer<AuthorizationData.Builder>... authorizationData);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private List<AuthorizationData> authorizationData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAuthorizationTokenResponse model) {
            super(model);
            authorizationData(model.authorizationData);
        }

        public final List<AuthorizationData.Builder> getAuthorizationData() {
            List<AuthorizationData.Builder> result = AuthorizationDataListCopier.copyToBuilder(this.authorizationData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthorizationData(Collection<AuthorizationData.BuilderImpl> authorizationData) {
            this.authorizationData = AuthorizationDataListCopier.copyFromBuilder(authorizationData);
        }

        @Override
        public final Builder authorizationData(Collection<AuthorizationData> authorizationData) {
            this.authorizationData = AuthorizationDataListCopier.copy(authorizationData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationData(AuthorizationData... authorizationData) {
            authorizationData(Arrays.asList(authorizationData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationData(Consumer<AuthorizationData.Builder>... authorizationData) {
            authorizationData(Stream.of(authorizationData).map(c -> AuthorizationData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetAuthorizationTokenResponse build() {
            return new GetAuthorizationTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
