/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImageSigningStatusResponse extends EcrResponse implements
        ToCopyableBuilder<DescribeImageSigningStatusResponse.Builder, DescribeImageSigningStatusResponse> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(DescribeImageSigningStatusResponse::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<ImageIdentifier> IMAGE_ID_FIELD = SdkField.<ImageIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("imageId").getter(getter(DescribeImageSigningStatusResponse::imageId)).setter(setter(Builder::imageId))
            .constructor(ImageIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()).build();

    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(DescribeImageSigningStatusResponse::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<List<ImageSigningStatus>> SIGNING_STATUSES_FIELD = SdkField
            .<List<ImageSigningStatus>> builder(MarshallingType.LIST)
            .memberName("signingStatuses")
            .getter(getter(DescribeImageSigningStatusResponse::signingStatuses))
            .setter(setter(Builder::signingStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageSigningStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageSigningStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            IMAGE_ID_FIELD, REGISTRY_ID_FIELD, SIGNING_STATUSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String repositoryName;

    private final ImageIdentifier imageId;

    private final String registryId;

    private final List<ImageSigningStatus> signingStatuses;

    private DescribeImageSigningStatusResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.imageId = builder.imageId;
        this.registryId = builder.registryId;
        this.signingStatuses = builder.signingStatuses;
    }

    /**
     * <p>
     * The name of the repository.
     * </p>
     * 
     * @return The name of the repository.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * An object with identifying information for the image.
     * </p>
     * 
     * @return An object with identifying information for the image.
     */
    public final ImageIdentifier imageId() {
        return imageId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the registry.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the registry.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SigningStatuses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSigningStatuses() {
        return signingStatuses != null && !(signingStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of signing statuses for the specified image. Each status corresponds to a signing profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSigningStatuses} method.
     * </p>
     * 
     * @return A list of signing statuses for the specified image. Each status corresponds to a signing profile.
     */
    public final List<ImageSigningStatus> signingStatuses() {
        return signingStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSigningStatuses() ? signingStatuses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageSigningStatusResponse)) {
            return false;
        }
        DescribeImageSigningStatusResponse other = (DescribeImageSigningStatusResponse) obj;
        return Objects.equals(repositoryName(), other.repositoryName()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(registryId(), other.registryId()) && hasSigningStatuses() == other.hasSigningStatuses()
                && Objects.equals(signingStatuses(), other.signingStatuses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImageSigningStatusResponse").add("RepositoryName", repositoryName())
                .add("ImageId", imageId()).add("RegistryId", registryId())
                .add("SigningStatuses", hasSigningStatuses() ? signingStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "imageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "signingStatuses":
            return Optional.ofNullable(clazz.cast(signingStatuses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("imageId", IMAGE_ID_FIELD);
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("signingStatuses", SIGNING_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageSigningStatusResponse, T> g) {
        return obj -> g.apply((DescribeImageSigningStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImageSigningStatusResponse> {
        /**
         * <p>
         * The name of the repository.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * An object with identifying information for the image.
         * </p>
         * 
         * @param imageId
         *        An object with identifying information for the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(ImageIdentifier imageId);

        /**
         * <p>
         * An object with identifying information for the image.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageIdentifier.Builder} avoiding the
         * need to create one manually via {@link ImageIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #imageId(ImageIdentifier)}.
         * 
         * @param imageId
         *        a consumer that will call methods on {@link ImageIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageId(ImageIdentifier)
         */
        default Builder imageId(Consumer<ImageIdentifier.Builder> imageId) {
            return imageId(ImageIdentifier.builder().applyMutation(imageId).build());
        }

        /**
         * <p>
         * The Amazon Web Services account ID associated with the registry.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account ID associated with the registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * A list of signing statuses for the specified image. Each status corresponds to a signing profile.
         * </p>
         * 
         * @param signingStatuses
         *        A list of signing statuses for the specified image. Each status corresponds to a signing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingStatuses(Collection<ImageSigningStatus> signingStatuses);

        /**
         * <p>
         * A list of signing statuses for the specified image. Each status corresponds to a signing profile.
         * </p>
         * 
         * @param signingStatuses
         *        A list of signing statuses for the specified image. Each status corresponds to a signing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingStatuses(ImageSigningStatus... signingStatuses);

        /**
         * <p>
         * A list of signing statuses for the specified image. Each status corresponds to a signing profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.ImageSigningStatus.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecr.model.ImageSigningStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecr.model.ImageSigningStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #signingStatuses(List<ImageSigningStatus>)}.
         * 
         * @param signingStatuses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecr.model.ImageSigningStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signingStatuses(java.util.Collection<ImageSigningStatus>)
         */
        Builder signingStatuses(Consumer<ImageSigningStatus.Builder>... signingStatuses);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private String repositoryName;

        private ImageIdentifier imageId;

        private String registryId;

        private List<ImageSigningStatus> signingStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageSigningStatusResponse model) {
            super(model);
            repositoryName(model.repositoryName);
            imageId(model.imageId);
            registryId(model.registryId);
            signingStatuses(model.signingStatuses);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final ImageIdentifier.Builder getImageId() {
            return imageId != null ? imageId.toBuilder() : null;
        }

        public final void setImageId(ImageIdentifier.BuilderImpl imageId) {
            this.imageId = imageId != null ? imageId.build() : null;
        }

        @Override
        public final Builder imageId(ImageIdentifier imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final List<ImageSigningStatus.Builder> getSigningStatuses() {
            List<ImageSigningStatus.Builder> result = ImageSigningStatusListCopier.copyToBuilder(this.signingStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSigningStatuses(Collection<ImageSigningStatus.BuilderImpl> signingStatuses) {
            this.signingStatuses = ImageSigningStatusListCopier.copyFromBuilder(signingStatuses);
        }

        @Override
        public final Builder signingStatuses(Collection<ImageSigningStatus> signingStatuses) {
            this.signingStatuses = ImageSigningStatusListCopier.copy(signingStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signingStatuses(ImageSigningStatus... signingStatuses) {
            signingStatuses(Arrays.asList(signingStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signingStatuses(Consumer<ImageSigningStatus.Builder>... signingStatuses) {
            signingStatuses(Stream.of(signingStatuses).map(c -> ImageSigningStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeImageSigningStatusResponse build() {
            return new DescribeImageSigningStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
