/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvalidLayerPartException
extends EcrException
implements ToCopyableBuilder<Builder, InvalidLayerPartException> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(InvalidLayerPartException.getter(InvalidLayerPartException::registryId)).setter(InvalidLayerPartException.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(InvalidLayerPartException.getter(InvalidLayerPartException::repositoryName)).setter(InvalidLayerPartException.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadId").getter(InvalidLayerPartException.getter(InvalidLayerPartException::uploadId)).setter(InvalidLayerPartException.setter(Builder::uploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()}).build();
    private static final SdkField<Long> LAST_VALID_BYTE_RECEIVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastValidByteReceived").getter(InvalidLayerPartException.getter(InvalidLayerPartException::lastValidByteReceived)).setter(InvalidLayerPartException.setter(Builder::lastValidByteReceived)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastValidByteReceived").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, UPLOAD_ID_FIELD, LAST_VALID_BYTE_RECEIVED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvalidLayerPartException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String registryId;
    private final String repositoryName;
    private final String uploadId;
    private final Long lastValidByteReceived;

    private InvalidLayerPartException(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.uploadId = builder.uploadId;
        this.lastValidByteReceived = builder.lastValidByteReceived;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public Long lastValidByteReceived() {
        return this.lastValidByteReceived;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("uploadId", UPLOAD_ID_FIELD);
        map.put("lastValidByteReceived", LAST_VALID_BYTE_RECEIVED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvalidLayerPartException, T> g) {
        return obj -> g.apply((InvalidLayerPartException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrException.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String uploadId;
        private Long lastValidByteReceived;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidLayerPartException model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.uploadId(model.uploadId);
            this.lastValidByteReceived(model.lastValidByteReceived);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final Long getLastValidByteReceived() {
            return this.lastValidByteReceived;
        }

        public final void setLastValidByteReceived(Long lastValidByteReceived) {
            this.lastValidByteReceived = lastValidByteReceived;
        }

        @Override
        public final Builder lastValidByteReceived(Long lastValidByteReceived) {
            this.lastValidByteReceived = lastValidByteReceived;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public InvalidLayerPartException build() {
            return new InvalidLayerPartException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvalidLayerPartException>,
    EcrException.Builder {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder uploadId(String var1);

        public Builder lastValidByteReceived(Long var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);

        @Override
        public Builder numAttempts(Integer var1);
    }
}

