/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecr.EcrAsyncClient;
import software.amazon.awssdk.services.ecr.internal.UserAgentUtils;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoryCreationTemplatesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoryCreationTemplatesResponse;
import software.amazon.awssdk.services.ecr.model.RepositoryCreationTemplate;

public class DescribeRepositoryCreationTemplatesPublisher
implements SdkPublisher<DescribeRepositoryCreationTemplatesResponse> {
    private final EcrAsyncClient client;
    private final DescribeRepositoryCreationTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRepositoryCreationTemplatesPublisher(EcrAsyncClient client, DescribeRepositoryCreationTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRepositoryCreationTemplatesPublisher(EcrAsyncClient client, DescribeRepositoryCreationTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRepositoryCreationTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRepositoryCreationTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RepositoryCreationTemplate> repositoryCreationTemplates() {
        Function<DescribeRepositoryCreationTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.repositoryCreationTemplates() != null) {
                return response.repositoryCreationTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRepositoryCreationTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRepositoryCreationTemplatesResponseFetcher
    implements AsyncPageFetcher<DescribeRepositoryCreationTemplatesResponse> {
        private DescribeRepositoryCreationTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRepositoryCreationTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRepositoryCreationTemplatesResponse> nextPage(DescribeRepositoryCreationTemplatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeRepositoryCreationTemplatesPublisher.this.client.describeRepositoryCreationTemplates(DescribeRepositoryCreationTemplatesPublisher.this.firstRequest);
            }
            return DescribeRepositoryCreationTemplatesPublisher.this.client.describeRepositoryCreationTemplates((DescribeRepositoryCreationTemplatesRequest)((Object)DescribeRepositoryCreationTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

