/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UpstreamRegistry {
    ECR("ecr"),
    ECR_PUBLIC("ecr-public"),
    QUAY("quay"),
    K8_S("k8s"),
    DOCKER_HUB("docker-hub"),
    GITHUB_CONTAINER_REGISTRY("github-container-registry"),
    AZURE_CONTAINER_REGISTRY("azure-container-registry"),
    GITLAB_CONTAINER_REGISTRY("gitlab-container-registry"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UpstreamRegistry> VALUE_MAP;
    private final String value;

    private UpstreamRegistry(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UpstreamRegistry fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UpstreamRegistry> knownValues() {
        EnumSet<UpstreamRegistry> knownValues = EnumSet.allOf(UpstreamRegistry.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UpstreamRegistry.class, UpstreamRegistry::toString);
    }
}

