/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidatePullThroughCacheRuleResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, ValidatePullThroughCacheRuleResponse> {
    private static final SdkField<String> ECR_REPOSITORY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ecrRepositoryPrefix").getter(ValidatePullThroughCacheRuleResponse.getter(ValidatePullThroughCacheRuleResponse::ecrRepositoryPrefix)).setter(ValidatePullThroughCacheRuleResponse.setter(Builder::ecrRepositoryPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryPrefix").build()}).build();
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(ValidatePullThroughCacheRuleResponse.getter(ValidatePullThroughCacheRuleResponse::registryId)).setter(ValidatePullThroughCacheRuleResponse.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> UPSTREAM_REGISTRY_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("upstreamRegistryUrl").getter(ValidatePullThroughCacheRuleResponse.getter(ValidatePullThroughCacheRuleResponse::upstreamRegistryUrl)).setter(ValidatePullThroughCacheRuleResponse.setter(Builder::upstreamRegistryUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRegistryUrl").build()}).build();
    private static final SdkField<String> CREDENTIAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialArn").getter(ValidatePullThroughCacheRuleResponse.getter(ValidatePullThroughCacheRuleResponse::credentialArn)).setter(ValidatePullThroughCacheRuleResponse.setter(Builder::credentialArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialArn").build()}).build();
    private static final SdkField<String> CUSTOM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customRoleArn").getter(ValidatePullThroughCacheRuleResponse.getter(ValidatePullThroughCacheRuleResponse::customRoleArn)).setter(ValidatePullThroughCacheRuleResponse.setter(Builder::customRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customRoleArn").build()}).build();
    private static final SdkField<String> UPSTREAM_REPOSITORY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("upstreamRepositoryPrefix").getter(ValidatePullThroughCacheRuleResponse.getter(ValidatePullThroughCacheRuleResponse::upstreamRepositoryPrefix)).setter(ValidatePullThroughCacheRuleResponse.setter(Builder::upstreamRepositoryPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRepositoryPrefix").build()}).build();
    private static final SdkField<Boolean> IS_VALID_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isValid").getter(ValidatePullThroughCacheRuleResponse.getter(ValidatePullThroughCacheRuleResponse::isValid)).setter(ValidatePullThroughCacheRuleResponse.setter(Builder::isValid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isValid").build()}).build();
    private static final SdkField<String> FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failure").getter(ValidatePullThroughCacheRuleResponse.getter(ValidatePullThroughCacheRuleResponse::failure)).setter(ValidatePullThroughCacheRuleResponse.setter(Builder::failure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failure").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECR_REPOSITORY_PREFIX_FIELD, REGISTRY_ID_FIELD, UPSTREAM_REGISTRY_URL_FIELD, CREDENTIAL_ARN_FIELD, CUSTOM_ROLE_ARN_FIELD, UPSTREAM_REPOSITORY_PREFIX_FIELD, IS_VALID_FIELD, FAILURE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ValidatePullThroughCacheRuleResponse.memberNameToFieldInitializer();
    private final String ecrRepositoryPrefix;
    private final String registryId;
    private final String upstreamRegistryUrl;
    private final String credentialArn;
    private final String customRoleArn;
    private final String upstreamRepositoryPrefix;
    private final Boolean isValid;
    private final String failure;

    private ValidatePullThroughCacheRuleResponse(BuilderImpl builder) {
        super(builder);
        this.ecrRepositoryPrefix = builder.ecrRepositoryPrefix;
        this.registryId = builder.registryId;
        this.upstreamRegistryUrl = builder.upstreamRegistryUrl;
        this.credentialArn = builder.credentialArn;
        this.customRoleArn = builder.customRoleArn;
        this.upstreamRepositoryPrefix = builder.upstreamRepositoryPrefix;
        this.isValid = builder.isValid;
        this.failure = builder.failure;
    }

    public final String ecrRepositoryPrefix() {
        return this.ecrRepositoryPrefix;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final String upstreamRegistryUrl() {
        return this.upstreamRegistryUrl;
    }

    public final String credentialArn() {
        return this.credentialArn;
    }

    public final String customRoleArn() {
        return this.customRoleArn;
    }

    public final String upstreamRepositoryPrefix() {
        return this.upstreamRepositoryPrefix;
    }

    public final Boolean isValid() {
        return this.isValid;
    }

    public final String failure() {
        return this.failure;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ecrRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.upstreamRegistryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.upstreamRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.isValid());
        hashCode = 31 * hashCode + Objects.hashCode(this.failure());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatePullThroughCacheRuleResponse)) {
            return false;
        }
        ValidatePullThroughCacheRuleResponse other = (ValidatePullThroughCacheRuleResponse)((Object)obj);
        return Objects.equals(this.ecrRepositoryPrefix(), other.ecrRepositoryPrefix()) && Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.upstreamRegistryUrl(), other.upstreamRegistryUrl()) && Objects.equals(this.credentialArn(), other.credentialArn()) && Objects.equals(this.customRoleArn(), other.customRoleArn()) && Objects.equals(this.upstreamRepositoryPrefix(), other.upstreamRepositoryPrefix()) && Objects.equals(this.isValid(), other.isValid()) && Objects.equals(this.failure(), other.failure());
    }

    public final String toString() {
        return ToString.builder((String)"ValidatePullThroughCacheRuleResponse").add("EcrRepositoryPrefix", (Object)this.ecrRepositoryPrefix()).add("RegistryId", (Object)this.registryId()).add("UpstreamRegistryUrl", (Object)this.upstreamRegistryUrl()).add("CredentialArn", (Object)this.credentialArn()).add("CustomRoleArn", (Object)this.customRoleArn()).add("UpstreamRepositoryPrefix", (Object)this.upstreamRepositoryPrefix()).add("IsValid", (Object)this.isValid()).add("Failure", (Object)this.failure()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ecrRepositoryPrefix": {
                return Optional.ofNullable(clazz.cast(this.ecrRepositoryPrefix()));
            }
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "upstreamRegistryUrl": {
                return Optional.ofNullable(clazz.cast(this.upstreamRegistryUrl()));
            }
            case "credentialArn": {
                return Optional.ofNullable(clazz.cast(this.credentialArn()));
            }
            case "customRoleArn": {
                return Optional.ofNullable(clazz.cast(this.customRoleArn()));
            }
            case "upstreamRepositoryPrefix": {
                return Optional.ofNullable(clazz.cast(this.upstreamRepositoryPrefix()));
            }
            case "isValid": {
                return Optional.ofNullable(clazz.cast(this.isValid()));
            }
            case "failure": {
                return Optional.ofNullable(clazz.cast(this.failure()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ecrRepositoryPrefix", ECR_REPOSITORY_PREFIX_FIELD);
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("upstreamRegistryUrl", UPSTREAM_REGISTRY_URL_FIELD);
        map.put("credentialArn", CREDENTIAL_ARN_FIELD);
        map.put("customRoleArn", CUSTOM_ROLE_ARN_FIELD);
        map.put("upstreamRepositoryPrefix", UPSTREAM_REPOSITORY_PREFIX_FIELD);
        map.put("isValid", IS_VALID_FIELD);
        map.put("failure", FAILURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidatePullThroughCacheRuleResponse, T> g) {
        return obj -> g.apply((ValidatePullThroughCacheRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private String ecrRepositoryPrefix;
        private String registryId;
        private String upstreamRegistryUrl;
        private String credentialArn;
        private String customRoleArn;
        private String upstreamRepositoryPrefix;
        private Boolean isValid;
        private String failure;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidatePullThroughCacheRuleResponse model) {
            super(model);
            this.ecrRepositoryPrefix(model.ecrRepositoryPrefix);
            this.registryId(model.registryId);
            this.upstreamRegistryUrl(model.upstreamRegistryUrl);
            this.credentialArn(model.credentialArn);
            this.customRoleArn(model.customRoleArn);
            this.upstreamRepositoryPrefix(model.upstreamRepositoryPrefix);
            this.isValid(model.isValid);
            this.failure(model.failure);
        }

        public final String getEcrRepositoryPrefix() {
            return this.ecrRepositoryPrefix;
        }

        public final void setEcrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
        }

        @Override
        public final Builder ecrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
            return this;
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getUpstreamRegistryUrl() {
            return this.upstreamRegistryUrl;
        }

        public final void setUpstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
        }

        @Override
        public final Builder upstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
            return this;
        }

        public final String getCredentialArn() {
            return this.credentialArn;
        }

        public final void setCredentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
        }

        @Override
        public final Builder credentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
            return this;
        }

        public final String getCustomRoleArn() {
            return this.customRoleArn;
        }

        public final void setCustomRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
        }

        @Override
        public final Builder customRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
            return this;
        }

        public final String getUpstreamRepositoryPrefix() {
            return this.upstreamRepositoryPrefix;
        }

        public final void setUpstreamRepositoryPrefix(String upstreamRepositoryPrefix) {
            this.upstreamRepositoryPrefix = upstreamRepositoryPrefix;
        }

        @Override
        public final Builder upstreamRepositoryPrefix(String upstreamRepositoryPrefix) {
            this.upstreamRepositoryPrefix = upstreamRepositoryPrefix;
            return this;
        }

        public final Boolean getIsValid() {
            return this.isValid;
        }

        public final void setIsValid(Boolean isValid) {
            this.isValid = isValid;
        }

        @Override
        public final Builder isValid(Boolean isValid) {
            this.isValid = isValid;
            return this;
        }

        public final String getFailure() {
            return this.failure;
        }

        public final void setFailure(String failure) {
            this.failure = failure;
        }

        @Override
        public final Builder failure(String failure) {
            this.failure = failure;
            return this;
        }

        @Override
        public ValidatePullThroughCacheRuleResponse build() {
            return new ValidatePullThroughCacheRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ValidatePullThroughCacheRuleResponse> {
        public Builder ecrRepositoryPrefix(String var1);

        public Builder registryId(String var1);

        public Builder upstreamRegistryUrl(String var1);

        public Builder credentialArn(String var1);

        public Builder customRoleArn(String var1);

        public Builder upstreamRepositoryPrefix(String var1);

        public Builder isValid(Boolean var1);

        public Builder failure(String var1);
    }
}

