/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.ScanFrequency;
import software.amazon.awssdk.services.ecr.model.ScanningRepositoryFilter;
import software.amazon.awssdk.services.ecr.model.ScanningRepositoryFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegistryScanningRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegistryScanningRule> {
    private static final SdkField<String> SCAN_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanFrequency").getter(RegistryScanningRule.getter(RegistryScanningRule::scanFrequencyAsString)).setter(RegistryScanningRule.setter(Builder::scanFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanFrequency").build()}).build();
    private static final SdkField<List<ScanningRepositoryFilter>> REPOSITORY_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("repositoryFilters").getter(RegistryScanningRule.getter(RegistryScanningRule::repositoryFilters)).setter(RegistryScanningRule.setter(Builder::repositoryFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScanningRepositoryFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_FREQUENCY_FIELD, REPOSITORY_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegistryScanningRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String scanFrequency;
    private final List<ScanningRepositoryFilter> repositoryFilters;

    private RegistryScanningRule(BuilderImpl builder) {
        this.scanFrequency = builder.scanFrequency;
        this.repositoryFilters = builder.repositoryFilters;
    }

    public final ScanFrequency scanFrequency() {
        return ScanFrequency.fromValue(this.scanFrequency);
    }

    public final String scanFrequencyAsString() {
        return this.scanFrequency;
    }

    public final boolean hasRepositoryFilters() {
        return this.repositoryFilters != null && !(this.repositoryFilters instanceof SdkAutoConstructList);
    }

    public final List<ScanningRepositoryFilter> repositoryFilters() {
        return this.repositoryFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scanFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepositoryFilters() ? this.repositoryFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistryScanningRule)) {
            return false;
        }
        RegistryScanningRule other = (RegistryScanningRule)obj;
        return Objects.equals(this.scanFrequencyAsString(), other.scanFrequencyAsString()) && this.hasRepositoryFilters() == other.hasRepositoryFilters() && Objects.equals(this.repositoryFilters(), other.repositoryFilters());
    }

    public final String toString() {
        return ToString.builder((String)"RegistryScanningRule").add("ScanFrequency", (Object)this.scanFrequencyAsString()).add("RepositoryFilters", this.hasRepositoryFilters() ? this.repositoryFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scanFrequency": {
                return Optional.ofNullable(clazz.cast(this.scanFrequencyAsString()));
            }
            case "repositoryFilters": {
                return Optional.ofNullable(clazz.cast(this.repositoryFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scanFrequency", SCAN_FREQUENCY_FIELD);
        map.put("repositoryFilters", REPOSITORY_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegistryScanningRule, T> g) {
        return obj -> g.apply((RegistryScanningRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scanFrequency;
        private List<ScanningRepositoryFilter> repositoryFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegistryScanningRule model) {
            this.scanFrequency(model.scanFrequency);
            this.repositoryFilters(model.repositoryFilters);
        }

        public final String getScanFrequency() {
            return this.scanFrequency;
        }

        public final void setScanFrequency(String scanFrequency) {
            this.scanFrequency = scanFrequency;
        }

        @Override
        public final Builder scanFrequency(String scanFrequency) {
            this.scanFrequency = scanFrequency;
            return this;
        }

        @Override
        public final Builder scanFrequency(ScanFrequency scanFrequency) {
            this.scanFrequency(scanFrequency == null ? null : scanFrequency.toString());
            return this;
        }

        public final List<ScanningRepositoryFilter.Builder> getRepositoryFilters() {
            List<ScanningRepositoryFilter.Builder> result = ScanningRepositoryFilterListCopier.copyToBuilder(this.repositoryFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositoryFilters(Collection<ScanningRepositoryFilter.BuilderImpl> repositoryFilters) {
            this.repositoryFilters = ScanningRepositoryFilterListCopier.copyFromBuilder(repositoryFilters);
        }

        @Override
        public final Builder repositoryFilters(Collection<ScanningRepositoryFilter> repositoryFilters) {
            this.repositoryFilters = ScanningRepositoryFilterListCopier.copy(repositoryFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryFilters(ScanningRepositoryFilter ... repositoryFilters) {
            this.repositoryFilters(Arrays.asList(repositoryFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryFilters(Consumer<ScanningRepositoryFilter.Builder> ... repositoryFilters) {
            this.repositoryFilters(Stream.of(repositoryFilters).map(c -> (ScanningRepositoryFilter)((ScanningRepositoryFilter.Builder)ScanningRepositoryFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RegistryScanningRule build() {
            return new RegistryScanningRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegistryScanningRule> {
        public Builder scanFrequency(String var1);

        public Builder scanFrequency(ScanFrequency var1);

        public Builder repositoryFilters(Collection<ScanningRepositoryFilter> var1);

        public Builder repositoryFilters(ScanningRepositoryFilter ... var1);

        public Builder repositoryFilters(Consumer<ScanningRepositoryFilter.Builder> ... var1);
    }
}

