/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.services.ecr.model.RepositoryCreationTemplate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRepositoryCreationTemplateResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, DeleteRepositoryCreationTemplateResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(DeleteRepositoryCreationTemplateResponse.getter(DeleteRepositoryCreationTemplateResponse::registryId)).setter(DeleteRepositoryCreationTemplateResponse.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<RepositoryCreationTemplate> REPOSITORY_CREATION_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("repositoryCreationTemplate").getter(DeleteRepositoryCreationTemplateResponse.getter(DeleteRepositoryCreationTemplateResponse::repositoryCreationTemplate)).setter(DeleteRepositoryCreationTemplateResponse.setter(Builder::repositoryCreationTemplate)).constructor(RepositoryCreationTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryCreationTemplate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_CREATION_TEMPLATE_FIELD));
    private final String registryId;
    private final RepositoryCreationTemplate repositoryCreationTemplate;

    private DeleteRepositoryCreationTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryCreationTemplate = builder.repositoryCreationTemplate;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final RepositoryCreationTemplate repositoryCreationTemplate() {
        return this.repositoryCreationTemplate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryCreationTemplate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRepositoryCreationTemplateResponse)) {
            return false;
        }
        DeleteRepositoryCreationTemplateResponse other = (DeleteRepositoryCreationTemplateResponse)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryCreationTemplate(), other.repositoryCreationTemplate());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRepositoryCreationTemplateResponse").add("RegistryId", (Object)this.registryId()).add("RepositoryCreationTemplate", (Object)this.repositoryCreationTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryCreationTemplate": {
                return Optional.ofNullable(clazz.cast(this.repositoryCreationTemplate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRepositoryCreationTemplateResponse, T> g) {
        return obj -> g.apply((DeleteRepositoryCreationTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private String registryId;
        private RepositoryCreationTemplate repositoryCreationTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRepositoryCreationTemplateResponse model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryCreationTemplate(model.repositoryCreationTemplate);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final RepositoryCreationTemplate.Builder getRepositoryCreationTemplate() {
            return this.repositoryCreationTemplate != null ? this.repositoryCreationTemplate.toBuilder() : null;
        }

        public final void setRepositoryCreationTemplate(RepositoryCreationTemplate.BuilderImpl repositoryCreationTemplate) {
            this.repositoryCreationTemplate = repositoryCreationTemplate != null ? repositoryCreationTemplate.build() : null;
        }

        @Override
        public final Builder repositoryCreationTemplate(RepositoryCreationTemplate repositoryCreationTemplate) {
            this.repositoryCreationTemplate = repositoryCreationTemplate;
            return this;
        }

        @Override
        public DeleteRepositoryCreationTemplateResponse build() {
            return new DeleteRepositoryCreationTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRepositoryCreationTemplateResponse> {
        public Builder registryId(String var1);

        public Builder repositoryCreationTemplate(RepositoryCreationTemplate var1);

        default public Builder repositoryCreationTemplate(Consumer<RepositoryCreationTemplate.Builder> repositoryCreationTemplate) {
            return this.repositoryCreationTemplate((RepositoryCreationTemplate)((RepositoryCreationTemplate.Builder)RepositoryCreationTemplate.builder().applyMutation(repositoryCreationTemplate)).build());
        }
    }
}

