/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.LayerAvailability;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Layer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Layer> {
    private static final SdkField<String> LAYER_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("layerDigest").getter(Layer.getter(Layer::layerDigest)).setter(Layer.setter(Builder::layerDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerDigest").build()}).build();
    private static final SdkField<String> LAYER_AVAILABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("layerAvailability").getter(Layer.getter(Layer::layerAvailabilityAsString)).setter(Layer.setter(Builder::layerAvailability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerAvailability").build()}).build();
    private static final SdkField<Long> LAYER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("layerSize").getter(Layer.getter(Layer::layerSize)).setter(Layer.setter(Builder::layerSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerSize").build()}).build();
    private static final SdkField<String> MEDIA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mediaType").getter(Layer.getter(Layer::mediaType)).setter(Layer.setter(Builder::mediaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_DIGEST_FIELD, LAYER_AVAILABILITY_FIELD, LAYER_SIZE_FIELD, MEDIA_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String layerDigest;
    private final String layerAvailability;
    private final Long layerSize;
    private final String mediaType;

    private Layer(BuilderImpl builder) {
        this.layerDigest = builder.layerDigest;
        this.layerAvailability = builder.layerAvailability;
        this.layerSize = builder.layerSize;
        this.mediaType = builder.mediaType;
    }

    public final String layerDigest() {
        return this.layerDigest;
    }

    public final LayerAvailability layerAvailability() {
        return LayerAvailability.fromValue(this.layerAvailability);
    }

    public final String layerAvailabilityAsString() {
        return this.layerAvailability;
    }

    public final Long layerSize() {
        return this.layerSize;
    }

    public final String mediaType() {
        return this.mediaType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.layerDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerAvailabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Layer)) {
            return false;
        }
        Layer other = (Layer)obj;
        return Objects.equals(this.layerDigest(), other.layerDigest()) && Objects.equals(this.layerAvailabilityAsString(), other.layerAvailabilityAsString()) && Objects.equals(this.layerSize(), other.layerSize()) && Objects.equals(this.mediaType(), other.mediaType());
    }

    public final String toString() {
        return ToString.builder((String)"Layer").add("LayerDigest", (Object)this.layerDigest()).add("LayerAvailability", (Object)this.layerAvailabilityAsString()).add("LayerSize", (Object)this.layerSize()).add("MediaType", (Object)this.mediaType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "layerDigest": {
                return Optional.ofNullable(clazz.cast(this.layerDigest()));
            }
            case "layerAvailability": {
                return Optional.ofNullable(clazz.cast(this.layerAvailabilityAsString()));
            }
            case "layerSize": {
                return Optional.ofNullable(clazz.cast(this.layerSize()));
            }
            case "mediaType": {
                return Optional.ofNullable(clazz.cast(this.mediaType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Layer, T> g) {
        return obj -> g.apply((Layer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String layerDigest;
        private String layerAvailability;
        private Long layerSize;
        private String mediaType;

        private BuilderImpl() {
        }

        private BuilderImpl(Layer model) {
            this.layerDigest(model.layerDigest);
            this.layerAvailability(model.layerAvailability);
            this.layerSize(model.layerSize);
            this.mediaType(model.mediaType);
        }

        public final String getLayerDigest() {
            return this.layerDigest;
        }

        public final void setLayerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
        }

        @Override
        @Transient
        public final Builder layerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
            return this;
        }

        public final String getLayerAvailability() {
            return this.layerAvailability;
        }

        public final void setLayerAvailability(String layerAvailability) {
            this.layerAvailability = layerAvailability;
        }

        @Override
        @Transient
        public final Builder layerAvailability(String layerAvailability) {
            this.layerAvailability = layerAvailability;
            return this;
        }

        @Override
        @Transient
        public final Builder layerAvailability(LayerAvailability layerAvailability) {
            this.layerAvailability(layerAvailability == null ? null : layerAvailability.toString());
            return this;
        }

        public final Long getLayerSize() {
            return this.layerSize;
        }

        public final void setLayerSize(Long layerSize) {
            this.layerSize = layerSize;
        }

        @Override
        @Transient
        public final Builder layerSize(Long layerSize) {
            this.layerSize = layerSize;
            return this;
        }

        public final String getMediaType() {
            return this.mediaType;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        @Override
        @Transient
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Layer build() {
            return new Layer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Layer> {
        public Builder layerDigest(String var1);

        public Builder layerAvailability(String var1);

        public Builder layerAvailability(LayerAvailability var1);

        public Builder layerSize(Long var1);

        public Builder mediaType(String var1);
    }
}

