/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartLifecyclePolicyPreviewResponse extends EcrResponse implements
        ToCopyableBuilder<StartLifecyclePolicyPreviewResponse.Builder, StartLifecyclePolicyPreviewResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(StartLifecyclePolicyPreviewResponse::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(StartLifecyclePolicyPreviewResponse::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> LIFECYCLE_POLICY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecyclePolicyText").getter(getter(StartLifecyclePolicyPreviewResponse::lifecyclePolicyText))
            .setter(setter(Builder::lifecyclePolicyText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicyText").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(StartLifecyclePolicyPreviewResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, LIFECYCLE_POLICY_TEXT_FIELD, STATUS_FIELD));

    private final String registryId;

    private final String repositoryName;

    private final String lifecyclePolicyText;

    private final String status;

    private StartLifecyclePolicyPreviewResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.lifecyclePolicyText = builder.lifecyclePolicyText;
        this.status = builder.status;
    }

    /**
     * <p>
     * The registry ID associated with the request.
     * </p>
     * 
     * @return The registry ID associated with the request.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The repository name associated with the request.
     * </p>
     * 
     * @return The repository name associated with the request.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The JSON repository policy text.
     * </p>
     * 
     * @return The JSON repository policy text.
     */
    public final String lifecyclePolicyText() {
        return lifecyclePolicyText;
    }

    /**
     * <p>
     * The status of the lifecycle policy preview request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LifecyclePolicyPreviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the lifecycle policy preview request.
     * @see LifecyclePolicyPreviewStatus
     */
    public final LifecyclePolicyPreviewStatus status() {
        return LifecyclePolicyPreviewStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the lifecycle policy preview request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LifecyclePolicyPreviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the lifecycle policy preview request.
     * @see LifecyclePolicyPreviewStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(lifecyclePolicyText());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartLifecyclePolicyPreviewResponse)) {
            return false;
        }
        StartLifecyclePolicyPreviewResponse other = (StartLifecyclePolicyPreviewResponse) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(lifecyclePolicyText(), other.lifecyclePolicyText())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartLifecyclePolicyPreviewResponse").add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("LifecyclePolicyText", lifecyclePolicyText())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "lifecyclePolicyText":
            return Optional.ofNullable(clazz.cast(lifecyclePolicyText()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartLifecyclePolicyPreviewResponse, T> g) {
        return obj -> g.apply((StartLifecyclePolicyPreviewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartLifecyclePolicyPreviewResponse> {
        /**
         * <p>
         * The registry ID associated with the request.
         * </p>
         * 
         * @param registryId
         *        The registry ID associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The repository name associated with the request.
         * </p>
         * 
         * @param repositoryName
         *        The repository name associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The JSON repository policy text.
         * </p>
         * 
         * @param lifecyclePolicyText
         *        The JSON repository policy text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicyText(String lifecyclePolicyText);

        /**
         * <p>
         * The status of the lifecycle policy preview request.
         * </p>
         * 
         * @param status
         *        The status of the lifecycle policy preview request.
         * @see LifecyclePolicyPreviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyPreviewStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the lifecycle policy preview request.
         * </p>
         * 
         * @param status
         *        The status of the lifecycle policy preview request.
         * @see LifecyclePolicyPreviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyPreviewStatus
         */
        Builder status(LifecyclePolicyPreviewStatus status);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private String lifecyclePolicyText;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StartLifecyclePolicyPreviewResponse model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            lifecyclePolicyText(model.lifecyclePolicyText);
            status(model.status);
        }

        public final String getRegistryId() {
            return registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getLifecyclePolicyText() {
            return lifecyclePolicyText;
        }

        @Override
        public final Builder lifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
            return this;
        }

        public final void setLifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecyclePolicyPreviewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public StartLifecyclePolicyPreviewResponse build() {
            return new StartLifecyclePolicyPreviewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
