/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The replication configuration for a registry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationConfiguration.Builder, ReplicationConfiguration> {
    private static final SdkField<List<ReplicationRule>> RULES_FIELD = SdkField
            .<List<ReplicationRule>> builder(MarshallingType.LIST)
            .memberName("rules")
            .getter(getter(ReplicationConfiguration::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ReplicationRule> rules;

    private ReplicationConfiguration(BuilderImpl builder) {
        this.rules = builder.rules;
    }

    /**
     * Returns true if the Rules property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects representing the replication rules for a replication configuration. A replication
     * configuration may contain only one replication rule but the rule may contain one or more replication
     * destinations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects representing the replication rules for a replication configuration. A replication
     *         configuration may contain only one replication rule but the rule may contain one or more replication
     *         destinations.
     */
    public final List<ReplicationRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationConfiguration)) {
            return false;
        }
        ReplicationConfiguration other = (ReplicationConfiguration) obj;
        return hasRules() == other.hasRules() && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationConfiguration").add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationConfiguration, T> g) {
        return obj -> g.apply((ReplicationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationConfiguration> {
        /**
         * <p>
         * An array of objects representing the replication rules for a replication configuration. A replication
         * configuration may contain only one replication rule but the rule may contain one or more replication
         * destinations.
         * </p>
         * 
         * @param rules
         *        An array of objects representing the replication rules for a replication configuration. A replication
         *        configuration may contain only one replication rule but the rule may contain one or more replication
         *        destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<ReplicationRule> rules);

        /**
         * <p>
         * An array of objects representing the replication rules for a replication configuration. A replication
         * configuration may contain only one replication rule but the rule may contain one or more replication
         * destinations.
         * </p>
         * 
         * @param rules
         *        An array of objects representing the replication rules for a replication configuration. A replication
         *        configuration may contain only one replication rule but the rule may contain one or more replication
         *        destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(ReplicationRule... rules);

        /**
         * <p>
         * An array of objects representing the replication rules for a replication configuration. A replication
         * configuration may contain only one replication rule but the rule may contain one or more replication
         * destinations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicationRule>.Builder} avoiding the need
         * to create one manually via {@link List<ReplicationRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicationRule>.Builder#build()} is called immediately and
         * its result is passed to {@link #rules(List<ReplicationRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<ReplicationRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<ReplicationRule>)
         */
        Builder rules(Consumer<ReplicationRule.Builder>... rules);
    }

    static final class BuilderImpl implements Builder {
        private List<ReplicationRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationConfiguration model) {
            rules(model.rules);
        }

        public final Collection<ReplicationRule.Builder> getRules() {
            if (rules instanceof SdkAutoConstructList) {
                return null;
            }
            return rules != null ? rules.stream().map(ReplicationRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<ReplicationRule> rules) {
            this.rules = ReplicationRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ReplicationRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<ReplicationRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> ReplicationRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<ReplicationRule.BuilderImpl> rules) {
            this.rules = ReplicationRuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public ReplicationConfiguration build() {
            return new ReplicationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
