/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRepositoriesRequest extends EcrRequest implements
        ToCopyableBuilder<DescribeRepositoriesRequest.Builder, DescribeRepositoriesRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(DescribeRepositoriesRequest::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<List<String>> REPOSITORY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("repositoryNames")
            .getter(getter(DescribeRepositoriesRequest::repositoryNames))
            .setter(setter(Builder::repositoryNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeRepositoriesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeRepositoriesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAMES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String registryId;

    private final List<String> repositoryNames;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeRepositoriesRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryNames = builder.repositoryNames;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The AWS account ID associated with the registry that contains the repositories to be described. If you do not
     * specify a registry, the default registry is assumed.
     * </p>
     * 
     * @return The AWS account ID associated with the registry that contains the repositories to be described. If you do
     *         not specify a registry, the default registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * Returns true if the RepositoryNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRepositoryNames() {
        return repositoryNames != null && !(repositoryNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of repositories to describe. If this parameter is omitted, then all repositories in a registry are
     * described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRepositoryNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of repositories to describe. If this parameter is omitted, then all repositories in a registry are
     *         described.
     */
    public final List<String> repositoryNames() {
        return repositoryNames;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>DescribeRepositories</code> request
     * where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues
     * from the end of the previous results that returned the <code>nextToken</code> value. This value is
     * <code>null</code> when there are no more results to return. This option cannot be used when you specify
     * repositories with <code>repositoryNames</code>.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>DescribeRepositories</code>
     *         request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
     *         Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
     *         This value is <code>null</code> when there are no more results to return. This option cannot be used when
     *         you specify repositories with <code>repositoryNames</code>.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of repository results returned by <code>DescribeRepositories</code> in paginated output. When
     * this parameter is used, <code>DescribeRepositories</code> only returns <code>maxResults</code> results in a
     * single page along with a <code>nextToken</code> response element. The remaining results of the initial request
     * can be seen by sending another <code>DescribeRepositories</code> request with the returned <code>nextToken</code>
     * value. This value can be between 1 and 1000. If this parameter is not used, then
     * <code>DescribeRepositories</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.
     * This option cannot be used when you specify repositories with <code>repositoryNames</code>.
     * </p>
     * 
     * @return The maximum number of repository results returned by <code>DescribeRepositories</code> in paginated
     *         output. When this parameter is used, <code>DescribeRepositories</code> only returns
     *         <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
     *         The remaining results of the initial request can be seen by sending another
     *         <code>DescribeRepositories</code> request with the returned <code>nextToken</code> value. This value can
     *         be between 1 and 1000. If this parameter is not used, then <code>DescribeRepositories</code> returns up
     *         to 100 results and a <code>nextToken</code> value, if applicable. This option cannot be used when you
     *         specify repositories with <code>repositoryNames</code>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRepositoryNames() ? repositoryNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRepositoriesRequest)) {
            return false;
        }
        DescribeRepositoriesRequest other = (DescribeRepositoriesRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && hasRepositoryNames() == other.hasRepositoryNames()
                && Objects.equals(repositoryNames(), other.repositoryNames()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRepositoriesRequest").add("RegistryId", registryId())
                .add("RepositoryNames", hasRepositoryNames() ? repositoryNames() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryNames":
            return Optional.ofNullable(clazz.cast(repositoryNames()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRepositoriesRequest, T> g) {
        return obj -> g.apply((DescribeRepositoriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRepositoriesRequest> {
        /**
         * <p>
         * The AWS account ID associated with the registry that contains the repositories to be described. If you do not
         * specify a registry, the default registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The AWS account ID associated with the registry that contains the repositories to be described. If you
         *        do not specify a registry, the default registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * A list of repositories to describe. If this parameter is omitted, then all repositories in a registry are
         * described.
         * </p>
         * 
         * @param repositoryNames
         *        A list of repositories to describe. If this parameter is omitted, then all repositories in a registry
         *        are described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryNames(Collection<String> repositoryNames);

        /**
         * <p>
         * A list of repositories to describe. If this parameter is omitted, then all repositories in a registry are
         * described.
         * </p>
         * 
         * @param repositoryNames
         *        A list of repositories to describe. If this parameter is omitted, then all repositories in a registry
         *        are described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryNames(String... repositoryNames);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>DescribeRepositories</code> request
         * where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
         * continues from the end of the previous results that returned the <code>nextToken</code> value. This value is
         * <code>null</code> when there are no more results to return. This option cannot be used when you specify
         * repositories with <code>repositoryNames</code>.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>DescribeRepositories</code>
         *        request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value. This value is <code>null</code> when there are no more results to return. This option cannot be
         *        used when you specify repositories with <code>repositoryNames</code>.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of repository results returned by <code>DescribeRepositories</code> in paginated output.
         * When this parameter is used, <code>DescribeRepositories</code> only returns <code>maxResults</code> results
         * in a single page along with a <code>nextToken</code> response element. The remaining results of the initial
         * request can be seen by sending another <code>DescribeRepositories</code> request with the returned
         * <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then
         * <code>DescribeRepositories</code> returns up to 100 results and a <code>nextToken</code> value, if
         * applicable. This option cannot be used when you specify repositories with <code>repositoryNames</code>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of repository results returned by <code>DescribeRepositories</code> in paginated
         *        output. When this parameter is used, <code>DescribeRepositories</code> only returns
         *        <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
         *        The remaining results of the initial request can be seen by sending another
         *        <code>DescribeRepositories</code> request with the returned <code>nextToken</code> value. This value
         *        can be between 1 and 1000. If this parameter is not used, then <code>DescribeRepositories</code>
         *        returns up to 100 results and a <code>nextToken</code> value, if applicable. This option cannot be
         *        used when you specify repositories with <code>repositoryNames</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private String registryId;

        private List<String> repositoryNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRepositoriesRequest model) {
            super(model);
            registryId(model.registryId);
            repositoryNames(model.repositoryNames);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getRegistryId() {
            return registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final Collection<String> getRepositoryNames() {
            if (repositoryNames instanceof SdkAutoConstructList) {
                return null;
            }
            return repositoryNames;
        }

        @Override
        public final Builder repositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNameListCopier.copy(repositoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryNames(String... repositoryNames) {
            repositoryNames(Arrays.asList(repositoryNames));
            return this;
        }

        public final void setRepositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNameListCopier.copy(repositoryNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRepositoriesRequest build() {
            return new DescribeRepositoriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
