/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2instanceconnect;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2instanceconnect.DefaultEc2InstanceConnectAsyncClient;
import software.amazon.awssdk.services.ec2instanceconnect.DefaultEc2InstanceConnectBaseClientBuilder;
import software.amazon.awssdk.services.ec2instanceconnect.Ec2InstanceConnectAsyncClient;
import software.amazon.awssdk.services.ec2instanceconnect.Ec2InstanceConnectAsyncClientBuilder;
import software.amazon.awssdk.services.ec2instanceconnect.Ec2InstanceConnectServiceClientConfiguration;
import software.amazon.awssdk.services.ec2instanceconnect.endpoints.Ec2InstanceConnectEndpointProvider;

@SdkInternalApi
final class DefaultEc2InstanceConnectAsyncClientBuilder
extends DefaultEc2InstanceConnectBaseClientBuilder<Ec2InstanceConnectAsyncClientBuilder, Ec2InstanceConnectAsyncClient>
implements Ec2InstanceConnectAsyncClientBuilder {
    DefaultEc2InstanceConnectAsyncClientBuilder() {
    }

    @Override
    public DefaultEc2InstanceConnectAsyncClientBuilder endpointProvider(Ec2InstanceConnectEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final Ec2InstanceConnectAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultEc2InstanceConnectAsyncClientBuilder.validateClientOptions(clientConfiguration);
        Ec2InstanceConnectServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEc2InstanceConnectAsyncClient client = new DefaultEc2InstanceConnectAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private Ec2InstanceConnectServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return Ec2InstanceConnectServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

