/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2instanceconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendSshPublicKeyResponse extends Ec2InstanceConnectResponse implements
        ToCopyableBuilder<SendSshPublicKeyResponse.Builder, SendSshPublicKeyResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SendSshPublicKeyResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Boolean> SUCCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(SendSshPublicKeyResponse::success)).setter(setter(Builder::success))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Success").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            SUCCESS_FIELD));

    private final String requestId;

    private final Boolean success;

    private SendSshPublicKeyResponse(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.success = builder.success;
    }

    /**
     * <p>
     * The request ID as logged by EC2 Connect. Please provide this when contacting AWS Support.
     * </p>
     * 
     * @return The request ID as logged by EC2 Connect. Please provide this when contacting AWS Support.
     */
    public String requestId() {
        return requestId;
    }

    /**
     * <p>
     * Indicates request success.
     * </p>
     * 
     * @return Indicates request success.
     */
    public Boolean success() {
        return success;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(success());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendSshPublicKeyResponse)) {
            return false;
        }
        SendSshPublicKeyResponse other = (SendSshPublicKeyResponse) obj;
        return Objects.equals(requestId(), other.requestId()) && Objects.equals(success(), other.success());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SendSshPublicKeyResponse").add("RequestId", requestId()).add("Success", success()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Success":
            return Optional.ofNullable(clazz.cast(success()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendSshPublicKeyResponse, T> g) {
        return obj -> g.apply((SendSshPublicKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2InstanceConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SendSshPublicKeyResponse> {
        /**
         * <p>
         * The request ID as logged by EC2 Connect. Please provide this when contacting AWS Support.
         * </p>
         * 
         * @param requestId
         *        The request ID as logged by EC2 Connect. Please provide this when contacting AWS Support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * Indicates request success.
         * </p>
         * 
         * @param success
         *        Indicates request success.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder success(Boolean success);
    }

    static final class BuilderImpl extends Ec2InstanceConnectResponse.BuilderImpl implements Builder {
        private String requestId;

        private Boolean success;

        private BuilderImpl() {
        }

        private BuilderImpl(SendSshPublicKeyResponse model) {
            super(model);
            requestId(model.requestId);
            success(model.success);
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Boolean getSuccess() {
            return success;
        }

        @Override
        public final Builder success(Boolean success) {
            this.success = success;
            return this;
        }

        public final void setSuccess(Boolean success) {
            this.success = success;
        }

        @Override
        public SendSshPublicKeyResponse build() {
            return new SendSshPublicKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
