/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2instanceconnect;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;

/**
 * This includes configuration specific to EC2 Instance Connect that is supported by both
 * {@link Ec2InstanceConnectClientBuilder} and {@link Ec2InstanceConnectAsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
public interface Ec2InstanceConnectBaseClientBuilder<B extends Ec2InstanceConnectBaseClientBuilder<B, C>, C> extends
        AwsClientBuilder<B, C> {
}
