/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ExportTaskIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExportTasksRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeExportTasksRequest> {
    private static final SdkField<List<String>> EXPORT_TASK_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeExportTasksRequest.getter(DescribeExportTasksRequest::exportTaskIds)).setter(DescribeExportTasksRequest.setter(Builder::exportTaskIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTaskId").unmarshallLocationName("exportTaskId").build(), ListTrait.builder().memberLocationName("ExportTaskId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTaskId").unmarshallLocationName("ExportTaskId").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_TASK_IDS_FIELD));
    private final List<String> exportTaskIds;

    private DescribeExportTasksRequest(BuilderImpl builder) {
        super(builder);
        this.exportTaskIds = builder.exportTaskIds;
    }

    public List<String> exportTaskIds() {
        return this.exportTaskIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.exportTaskIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksRequest)) {
            return false;
        }
        DescribeExportTasksRequest other = (DescribeExportTasksRequest)((Object)obj);
        return Objects.equals(this.exportTaskIds(), other.exportTaskIds());
    }

    public String toString() {
        return ToString.builder((String)"DescribeExportTasksRequest").add("ExportTaskIds", this.exportTaskIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportTaskIds": {
                return Optional.ofNullable(clazz.cast(this.exportTaskIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExportTasksRequest, T> g) {
        return obj -> g.apply((DescribeExportTasksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> exportTaskIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksRequest model) {
            super(model);
            this.exportTaskIds(model.exportTaskIds);
        }

        public final Collection<String> getExportTaskIds() {
            return this.exportTaskIds;
        }

        @Override
        public final Builder exportTaskIds(Collection<String> exportTaskIds) {
            this.exportTaskIds = ExportTaskIdStringListCopier.copy(exportTaskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTaskIds(String ... exportTaskIds) {
            this.exportTaskIds(Arrays.asList(exportTaskIds));
            return this;
        }

        public final void setExportTaskIds(Collection<String> exportTaskIds) {
            this.exportTaskIds = ExportTaskIdStringListCopier.copy(exportTaskIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeExportTasksRequest build() {
            return new DescribeExportTasksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeExportTasksRequest> {
        public Builder exportTaskIds(Collection<String> var1);

        public Builder exportTaskIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

