/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ClientCertificateRevocationListStatusCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClientCertificateRevocationListStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClientCertificateRevocationListStatus> {
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClientCertificateRevocationListStatus.getter(ClientCertificateRevocationListStatus::codeAsString)).setter(ClientCertificateRevocationListStatus.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").unmarshallLocationName("code").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClientCertificateRevocationListStatus.getter(ClientCertificateRevocationListStatus::message)).setter(ClientCertificateRevocationListStatus.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").unmarshallLocationName("message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String code;
    private final String message;

    private ClientCertificateRevocationListStatus(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    public ClientCertificateRevocationListStatusCode code() {
        return ClientCertificateRevocationListStatusCode.fromValue(this.code);
    }

    public String codeAsString() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientCertificateRevocationListStatus)) {
            return false;
        }
        ClientCertificateRevocationListStatus other = (ClientCertificateRevocationListStatus)obj;
        return Objects.equals(this.codeAsString(), other.codeAsString()) && Objects.equals(this.message(), other.message());
    }

    public String toString() {
        return ToString.builder((String)"ClientCertificateRevocationListStatus").add("Code", (Object)this.codeAsString()).add("Message", (Object)this.message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.codeAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientCertificateRevocationListStatus, T> g) {
        return obj -> g.apply((ClientCertificateRevocationListStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientCertificateRevocationListStatus model) {
            this.code(model.code);
            this.message(model.message);
        }

        public final String getCodeAsString() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(ClientCertificateRevocationListStatusCode code) {
            this.code(code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public ClientCertificateRevocationListStatus build() {
            return new ClientCertificateRevocationListStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClientCertificateRevocationListStatus> {
        public Builder code(String var1);

        public Builder code(ClientCertificateRevocationListStatusCode var1);

        public Builder message(String var1);
    }
}

