/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ConversionTask;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTaskListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConversionTasksResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeConversionTasksResponse> {
    private static final SdkField<List<ConversionTask>> CONVERSION_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeConversionTasksResponse.getter(DescribeConversionTasksResponse::conversionTasks)).setter(DescribeConversionTasksResponse.setter(Builder::conversionTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConversionTasks").unmarshallLocationName("conversionTasks").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConversionTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSION_TASKS_FIELD));
    private final List<ConversionTask> conversionTasks;

    private DescribeConversionTasksResponse(BuilderImpl builder) {
        super(builder);
        this.conversionTasks = builder.conversionTasks;
    }

    public List<ConversionTask> conversionTasks() {
        return this.conversionTasks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conversionTasks());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConversionTasksResponse)) {
            return false;
        }
        DescribeConversionTasksResponse other = (DescribeConversionTasksResponse)((Object)obj);
        return Objects.equals(this.conversionTasks(), other.conversionTasks());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConversionTasksResponse").add("ConversionTasks", this.conversionTasks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConversionTasks": {
                return Optional.ofNullable(clazz.cast(this.conversionTasks()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConversionTasksResponse, T> g) {
        return obj -> g.apply((DescribeConversionTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ConversionTask> conversionTasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConversionTasksResponse model) {
            super(model);
            this.conversionTasks(model.conversionTasks);
        }

        public final Collection<ConversionTask.Builder> getConversionTasks() {
            return this.conversionTasks != null ? (Collection)this.conversionTasks.stream().map(ConversionTask::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conversionTasks(Collection<ConversionTask> conversionTasks) {
            this.conversionTasks = DescribeConversionTaskListCopier.copy(conversionTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversionTasks(ConversionTask ... conversionTasks) {
            this.conversionTasks(Arrays.asList(conversionTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversionTasks(Consumer<ConversionTask.Builder> ... conversionTasks) {
            this.conversionTasks(Stream.of(conversionTasks).map(c -> (ConversionTask)((ConversionTask.Builder)ConversionTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConversionTasks(Collection<ConversionTask.BuilderImpl> conversionTasks) {
            this.conversionTasks = DescribeConversionTaskListCopier.copyFromBuilder(conversionTasks);
        }

        @Override
        public DescribeConversionTasksResponse build() {
            return new DescribeConversionTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConversionTasksResponse> {
        public Builder conversionTasks(Collection<ConversionTask> var1);

        public Builder conversionTasks(ConversionTask ... var1);

        public Builder conversionTasks(Consumer<ConversionTask.Builder> ... var1);
    }
}

