/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AllocationState {
    AVAILABLE("available"),
    UNDER_ASSESSMENT("under-assessment"),
    PERMANENT_FAILURE("permanent-failure"),
    RELEASED("released"),
    RELEASED_PERMANENT_FAILURE("released-permanent-failure"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AllocationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AllocationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AllocationState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AllocationState> knownValues() {
        return Stream.of(AllocationState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

