/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpRangesCopier;
import software.amazon.awssdk.services.ec2.model.PrefixListIdSetCopier;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPair;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPairSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StaleIpPermission
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StaleIpPermission> {
    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(StaleIpPermission.getter(StaleIpPermission::fromPort)).setter(StaleIpPermission.setter(Builder::fromPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort").unmarshallLocationName("fromPort").build()}).build();
    private static final SdkField<String> IP_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StaleIpPermission.getter(StaleIpPermission::ipProtocol)).setter(StaleIpPermission.setter(Builder::ipProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpProtocol").unmarshallLocationName("ipProtocol").build()}).build();
    private static final SdkField<List<String>> IP_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StaleIpPermission.getter(StaleIpPermission::ipRanges)).setter(StaleIpPermission.setter(Builder::ipRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRanges").unmarshallLocationName("ipRanges").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PREFIX_LIST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StaleIpPermission.getter(StaleIpPermission::prefixListIds)).setter(StaleIpPermission.setter(Builder::prefixListIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListIds").unmarshallLocationName("prefixListIds").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> TO_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(StaleIpPermission.getter(StaleIpPermission::toPort)).setter(StaleIpPermission.setter(Builder::toPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort").unmarshallLocationName("toPort").build()}).build();
    private static final SdkField<List<UserIdGroupPair>> USER_ID_GROUP_PAIRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StaleIpPermission.getter(StaleIpPermission::userIdGroupPairs)).setter(StaleIpPermission.setter(Builder::userIdGroupPairs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").unmarshallLocationName("groups").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserIdGroupPair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_PORT_FIELD, IP_PROTOCOL_FIELD, IP_RANGES_FIELD, PREFIX_LIST_IDS_FIELD, TO_PORT_FIELD, USER_ID_GROUP_PAIRS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer fromPort;
    private final String ipProtocol;
    private final List<String> ipRanges;
    private final List<String> prefixListIds;
    private final Integer toPort;
    private final List<UserIdGroupPair> userIdGroupPairs;

    private StaleIpPermission(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.ipProtocol = builder.ipProtocol;
        this.ipRanges = builder.ipRanges;
        this.prefixListIds = builder.prefixListIds;
        this.toPort = builder.toPort;
        this.userIdGroupPairs = builder.userIdGroupPairs;
    }

    public Integer fromPort() {
        return this.fromPort;
    }

    public String ipProtocol() {
        return this.ipProtocol;
    }

    public List<String> ipRanges() {
        return this.ipRanges;
    }

    public List<String> prefixListIds() {
        return this.prefixListIds;
    }

    public Integer toPort() {
        return this.toPort;
    }

    public List<UserIdGroupPair> userIdGroupPairs() {
        return this.userIdGroupPairs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipRanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.toPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIdGroupPairs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaleIpPermission)) {
            return false;
        }
        StaleIpPermission other = (StaleIpPermission)obj;
        return Objects.equals(this.fromPort(), other.fromPort()) && Objects.equals(this.ipProtocol(), other.ipProtocol()) && Objects.equals(this.ipRanges(), other.ipRanges()) && Objects.equals(this.prefixListIds(), other.prefixListIds()) && Objects.equals(this.toPort(), other.toPort()) && Objects.equals(this.userIdGroupPairs(), other.userIdGroupPairs());
    }

    public String toString() {
        return ToString.builder((String)"StaleIpPermission").add("FromPort", (Object)this.fromPort()).add("IpProtocol", (Object)this.ipProtocol()).add("IpRanges", this.ipRanges()).add("PrefixListIds", this.prefixListIds()).add("ToPort", (Object)this.toPort()).add("UserIdGroupPairs", this.userIdGroupPairs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FromPort": {
                return Optional.ofNullable(clazz.cast(this.fromPort()));
            }
            case "IpProtocol": {
                return Optional.ofNullable(clazz.cast(this.ipProtocol()));
            }
            case "IpRanges": {
                return Optional.ofNullable(clazz.cast(this.ipRanges()));
            }
            case "PrefixListIds": {
                return Optional.ofNullable(clazz.cast(this.prefixListIds()));
            }
            case "ToPort": {
                return Optional.ofNullable(clazz.cast(this.toPort()));
            }
            case "UserIdGroupPairs": {
                return Optional.ofNullable(clazz.cast(this.userIdGroupPairs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StaleIpPermission, T> g) {
        return obj -> g.apply((StaleIpPermission)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fromPort;
        private String ipProtocol;
        private List<String> ipRanges = DefaultSdkAutoConstructList.getInstance();
        private List<String> prefixListIds = DefaultSdkAutoConstructList.getInstance();
        private Integer toPort;
        private List<UserIdGroupPair> userIdGroupPairs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StaleIpPermission model) {
            this.fromPort(model.fromPort);
            this.ipProtocol(model.ipProtocol);
            this.ipRanges(model.ipRanges);
            this.prefixListIds(model.prefixListIds);
            this.toPort(model.toPort);
            this.userIdGroupPairs(model.userIdGroupPairs);
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final String getIpProtocol() {
            return this.ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final Collection<String> getIpRanges() {
            return this.ipRanges;
        }

        @Override
        public final Builder ipRanges(Collection<String> ipRanges) {
            this.ipRanges = IpRangesCopier.copy(ipRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(String ... ipRanges) {
            this.ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        public final void setIpRanges(Collection<String> ipRanges) {
            this.ipRanges = IpRangesCopier.copy(ipRanges);
        }

        public final Collection<String> getPrefixListIds() {
            return this.prefixListIds;
        }

        @Override
        public final Builder prefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = PrefixListIdSetCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(String ... prefixListIds) {
            this.prefixListIds(Arrays.asList(prefixListIds));
            return this;
        }

        public final void setPrefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = PrefixListIdSetCopier.copy(prefixListIds);
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final Collection<UserIdGroupPair.Builder> getUserIdGroupPairs() {
            return this.userIdGroupPairs != null ? (Collection)this.userIdGroupPairs.stream().map(UserIdGroupPair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairSetCopier.copy(userIdGroupPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(UserIdGroupPair ... userIdGroupPairs) {
            this.userIdGroupPairs(Arrays.asList(userIdGroupPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(Consumer<UserIdGroupPair.Builder> ... userIdGroupPairs) {
            this.userIdGroupPairs(Stream.of(userIdGroupPairs).map(c -> (UserIdGroupPair)((UserIdGroupPair.Builder)UserIdGroupPair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserIdGroupPairs(Collection<UserIdGroupPair.BuilderImpl> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairSetCopier.copyFromBuilder(userIdGroupPairs);
        }

        public StaleIpPermission build() {
            return new StaleIpPermission(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StaleIpPermission> {
        public Builder fromPort(Integer var1);

        public Builder ipProtocol(String var1);

        public Builder ipRanges(Collection<String> var1);

        public Builder ipRanges(String ... var1);

        public Builder prefixListIds(Collection<String> var1);

        public Builder prefixListIds(String ... var1);

        public Builder toPort(Integer var1);

        public Builder userIdGroupPairs(Collection<UserIdGroupPair> var1);

        public Builder userIdGroupPairs(UserIdGroupPair ... var1);

        public Builder userIdGroupPairs(Consumer<UserIdGroupPair.Builder> ... var1);
    }
}

