/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSecondaryInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecondaryInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.SecondaryInterface;

public class DescribeSecondaryInterfacesPublisher
implements SdkPublisher<DescribeSecondaryInterfacesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeSecondaryInterfacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSecondaryInterfacesPublisher(Ec2AsyncClient client, DescribeSecondaryInterfacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSecondaryInterfacesPublisher(Ec2AsyncClient client, DescribeSecondaryInterfacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSecondaryInterfacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSecondaryInterfacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecondaryInterface> secondaryInterfaces() {
        return this.flatMapIterable(response -> response.secondaryInterfaces());
    }

    private class DescribeSecondaryInterfacesResponseFetcher
    implements AsyncPageFetcher<DescribeSecondaryInterfacesResponse> {
        private DescribeSecondaryInterfacesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSecondaryInterfacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSecondaryInterfacesResponse> nextPage(DescribeSecondaryInterfacesResponse previousPage) {
            if (previousPage == null) {
                return DescribeSecondaryInterfacesPublisher.this.client.describeSecondaryInterfaces(DescribeSecondaryInterfacesPublisher.this.firstRequest);
            }
            return DescribeSecondaryInterfacesPublisher.this.client.describeSecondaryInterfaces((DescribeSecondaryInterfacesRequest)((Object)DescribeSecondaryInterfacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

