/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.ClientVpnConnection;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsResponse;

public class DescribeClientVpnConnectionsPublisher
implements SdkPublisher<DescribeClientVpnConnectionsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeClientVpnConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClientVpnConnectionsPublisher(Ec2AsyncClient client, DescribeClientVpnConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClientVpnConnectionsPublisher(Ec2AsyncClient client, DescribeClientVpnConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClientVpnConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClientVpnConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClientVpnConnection> connections() {
        return this.flatMapIterable(response -> response.connections());
    }

    private class DescribeClientVpnConnectionsResponseFetcher
    implements AsyncPageFetcher<DescribeClientVpnConnectionsResponse> {
        private DescribeClientVpnConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClientVpnConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeClientVpnConnectionsResponse> nextPage(DescribeClientVpnConnectionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClientVpnConnectionsPublisher.this.client.describeClientVpnConnections(DescribeClientVpnConnectionsPublisher.this.firstRequest);
            }
            return DescribeClientVpnConnectionsPublisher.this.client.describeClientVpnConnections((DescribeClientVpnConnectionsRequest)((Object)DescribeClientVpnConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

