/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSecondaryInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecondaryInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.SecondaryInterface;

public class DescribeSecondaryInterfacesIterable
implements SdkIterable<DescribeSecondaryInterfacesResponse> {
    private final Ec2Client client;
    private final DescribeSecondaryInterfacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSecondaryInterfacesIterable(Ec2Client client, DescribeSecondaryInterfacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSecondaryInterfacesResponseFetcher();
    }

    public Iterator<DescribeSecondaryInterfacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SecondaryInterface> secondaryInterfaces() {
        Function<DescribeSecondaryInterfacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.secondaryInterfaces() != null) {
                return response.secondaryInterfaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSecondaryInterfacesResponseFetcher
    implements SyncPageFetcher<DescribeSecondaryInterfacesResponse> {
        private DescribeSecondaryInterfacesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSecondaryInterfacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSecondaryInterfacesResponse nextPage(DescribeSecondaryInterfacesResponse previousPage) {
            if (previousPage == null) {
                return DescribeSecondaryInterfacesIterable.this.client.describeSecondaryInterfaces(DescribeSecondaryInterfacesIterable.this.firstRequest);
            }
            return DescribeSecondaryInterfacesIterable.this.client.describeSecondaryInterfaces((DescribeSecondaryInterfacesRequest)((Object)DescribeSecondaryInterfacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

