/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.PrincipalIdFormat;

public class DescribePrincipalIdFormatPublisher
implements SdkPublisher<DescribePrincipalIdFormatResponse> {
    private final Ec2AsyncClient client;
    private final DescribePrincipalIdFormatRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribePrincipalIdFormatPublisher(Ec2AsyncClient client, DescribePrincipalIdFormatRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribePrincipalIdFormatPublisher(Ec2AsyncClient client, DescribePrincipalIdFormatRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribePrincipalIdFormatResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribePrincipalIdFormatResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PrincipalIdFormat> principals() {
        return this.flatMapIterable(response -> response.principals());
    }

    private class DescribePrincipalIdFormatResponseFetcher
    implements AsyncPageFetcher<DescribePrincipalIdFormatResponse> {
        private DescribePrincipalIdFormatResponseFetcher() {
        }

        public boolean hasNextPage(DescribePrincipalIdFormatResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribePrincipalIdFormatResponse> nextPage(DescribePrincipalIdFormatResponse previousPage) {
            if (previousPage == null) {
                return DescribePrincipalIdFormatPublisher.this.client.describePrincipalIdFormat(DescribePrincipalIdFormatPublisher.this.firstRequest);
            }
            return DescribePrincipalIdFormatPublisher.this.client.describePrincipalIdFormat((DescribePrincipalIdFormatRequest)((Object)DescribePrincipalIdFormatPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

