/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CapacityReservationTenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityBlockExtensionOffering
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityBlockExtensionOffering> {
    private static final SdkField<String> CAPACITY_BLOCK_EXTENSION_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityBlockExtensionOfferingId").getter(CapacityBlockExtensionOffering.getter(CapacityBlockExtensionOffering::capacityBlockExtensionOfferingId)).setter(CapacityBlockExtensionOffering.setter(Builder::capacityBlockExtensionOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionOfferingId").unmarshallLocationName("capacityBlockExtensionOfferingId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(CapacityBlockExtensionOffering.getter(CapacityBlockExtensionOffering::instanceType)).setter(CapacityBlockExtensionOffering.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(CapacityBlockExtensionOffering.getter(CapacityBlockExtensionOffering::instanceCount)).setter(CapacityBlockExtensionOffering.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("instanceCount").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(CapacityBlockExtensionOffering.getter(CapacityBlockExtensionOffering::availabilityZone)).setter(CapacityBlockExtensionOffering.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(CapacityBlockExtensionOffering.getter(CapacityBlockExtensionOffering::availabilityZoneId)).setter(CapacityBlockExtensionOffering.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("availabilityZoneId").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(CapacityBlockExtensionOffering.getter(CapacityBlockExtensionOffering::startDate)).setter(CapacityBlockExtensionOffering.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").unmarshallLocationName("startDate").build()}).build();
    private static final SdkField<Instant> CAPACITY_BLOCK_EXTENSION_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CapacityBlockExtensionStartDate").getter(CapacityBlockExtensionOffering.getter(CapacityBlockExtensionOffering::capacityBlockExtensionStartDate)).setter(CapacityBlockExtensionOffering.setter(Builder::capacityBlockExtensionStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionStartDate").unmarshallLocationName("capacityBlockExtensionStartDate").build()}).build();
    private static final SdkField<Instant> CAPACITY_BLOCK_EXTENSION_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CapacityBlockExtensionEndDate").getter(CapacityBlockExtensionOffering.getter(CapacityBlockExtensionOffering::capacityBlockExtensionEndDate)).setter(CapacityBlockExtensionOffering.setter(Builder::capacityBlockExtensionEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionEndDate").unmarshallLocationName("capacityBlockExtensionEndDate").build()}).build();
    private static final SdkField<Integer> CAPACITY_BLOCK_EXTENSION_DURATION_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CapacityBlockExtensionDurationHours").getter(CapacityBlockExtensionOffering.getter(CapacityBlockExtensionOffering::capacityBlockExtensionDurationHours)).setter(CapacityBlockExtensionOffering.setter(Builder::capacityBlockExtensionDurationHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionDurationHours").unmarshallLocationName("capacityBlockExtensionDurationHours").build()}).build();
    private static final SdkField<String> UPFRONT_FEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpfrontFee").getter(CapacityBlockExtensionOffering.getter(CapacityBlockExtensionOffering::upfrontFee)).setter(CapacityBlockExtensionOffering.setter(Builder::upfrontFee)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontFee").unmarshallLocationName("upfrontFee").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(CapacityBlockExtensionOffering.getter(CapacityBlockExtensionOffering::currencyCode)).setter(CapacityBlockExtensionOffering.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").unmarshallLocationName("currencyCode").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tenancy").getter(CapacityBlockExtensionOffering.getter(CapacityBlockExtensionOffering::tenancyAsString)).setter(CapacityBlockExtensionOffering.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").unmarshallLocationName("tenancy").build()}).build();
    private static final SdkField<String> ZONE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZoneType").getter(CapacityBlockExtensionOffering.getter(CapacityBlockExtensionOffering::zoneType)).setter(CapacityBlockExtensionOffering.setter(Builder::zoneType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneType").unmarshallLocationName("zoneType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_BLOCK_EXTENSION_OFFERING_ID_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_COUNT_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, START_DATE_FIELD, CAPACITY_BLOCK_EXTENSION_START_DATE_FIELD, CAPACITY_BLOCK_EXTENSION_END_DATE_FIELD, CAPACITY_BLOCK_EXTENSION_DURATION_HOURS_FIELD, UPFRONT_FEE_FIELD, CURRENCY_CODE_FIELD, TENANCY_FIELD, ZONE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityBlockExtensionOffering.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String capacityBlockExtensionOfferingId;
    private final String instanceType;
    private final Integer instanceCount;
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final Instant startDate;
    private final Instant capacityBlockExtensionStartDate;
    private final Instant capacityBlockExtensionEndDate;
    private final Integer capacityBlockExtensionDurationHours;
    private final String upfrontFee;
    private final String currencyCode;
    private final String tenancy;
    private final String zoneType;

    private CapacityBlockExtensionOffering(BuilderImpl builder) {
        this.capacityBlockExtensionOfferingId = builder.capacityBlockExtensionOfferingId;
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.startDate = builder.startDate;
        this.capacityBlockExtensionStartDate = builder.capacityBlockExtensionStartDate;
        this.capacityBlockExtensionEndDate = builder.capacityBlockExtensionEndDate;
        this.capacityBlockExtensionDurationHours = builder.capacityBlockExtensionDurationHours;
        this.upfrontFee = builder.upfrontFee;
        this.currencyCode = builder.currencyCode;
        this.tenancy = builder.tenancy;
        this.zoneType = builder.zoneType;
    }

    public final String capacityBlockExtensionOfferingId() {
        return this.capacityBlockExtensionOfferingId;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant capacityBlockExtensionStartDate() {
        return this.capacityBlockExtensionStartDate;
    }

    public final Instant capacityBlockExtensionEndDate() {
        return this.capacityBlockExtensionEndDate;
    }

    public final Integer capacityBlockExtensionDurationHours() {
        return this.capacityBlockExtensionDurationHours;
    }

    public final String upfrontFee() {
        return this.upfrontFee;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final CapacityReservationTenancy tenancy() {
        return CapacityReservationTenancy.fromValue(this.tenancy);
    }

    public final String tenancyAsString() {
        return this.tenancy;
    }

    public final String zoneType() {
        return this.zoneType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityBlockExtensionOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityBlockExtensionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityBlockExtensionEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityBlockExtensionDurationHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.upfrontFee());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityBlockExtensionOffering)) {
            return false;
        }
        CapacityBlockExtensionOffering other = (CapacityBlockExtensionOffering)obj;
        return Objects.equals(this.capacityBlockExtensionOfferingId(), other.capacityBlockExtensionOfferingId()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.capacityBlockExtensionStartDate(), other.capacityBlockExtensionStartDate()) && Objects.equals(this.capacityBlockExtensionEndDate(), other.capacityBlockExtensionEndDate()) && Objects.equals(this.capacityBlockExtensionDurationHours(), other.capacityBlockExtensionDurationHours()) && Objects.equals(this.upfrontFee(), other.upfrontFee()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && Objects.equals(this.zoneType(), other.zoneType());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityBlockExtensionOffering").add("CapacityBlockExtensionOfferingId", (Object)this.capacityBlockExtensionOfferingId()).add("InstanceType", (Object)this.instanceType()).add("InstanceCount", (Object)this.instanceCount()).add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("StartDate", (Object)this.startDate()).add("CapacityBlockExtensionStartDate", (Object)this.capacityBlockExtensionStartDate()).add("CapacityBlockExtensionEndDate", (Object)this.capacityBlockExtensionEndDate()).add("CapacityBlockExtensionDurationHours", (Object)this.capacityBlockExtensionDurationHours()).add("UpfrontFee", (Object)this.upfrontFee()).add("CurrencyCode", (Object)this.currencyCode()).add("Tenancy", (Object)this.tenancyAsString()).add("ZoneType", (Object)this.zoneType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityBlockExtensionOfferingId": {
                return Optional.ofNullable(clazz.cast(this.capacityBlockExtensionOfferingId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "CapacityBlockExtensionStartDate": {
                return Optional.ofNullable(clazz.cast(this.capacityBlockExtensionStartDate()));
            }
            case "CapacityBlockExtensionEndDate": {
                return Optional.ofNullable(clazz.cast(this.capacityBlockExtensionEndDate()));
            }
            case "CapacityBlockExtensionDurationHours": {
                return Optional.ofNullable(clazz.cast(this.capacityBlockExtensionDurationHours()));
            }
            case "UpfrontFee": {
                return Optional.ofNullable(clazz.cast(this.upfrontFee()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "ZoneType": {
                return Optional.ofNullable(clazz.cast(this.zoneType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityBlockExtensionOfferingId", CAPACITY_BLOCK_EXTENSION_OFFERING_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("CapacityBlockExtensionStartDate", CAPACITY_BLOCK_EXTENSION_START_DATE_FIELD);
        map.put("CapacityBlockExtensionEndDate", CAPACITY_BLOCK_EXTENSION_END_DATE_FIELD);
        map.put("CapacityBlockExtensionDurationHours", CAPACITY_BLOCK_EXTENSION_DURATION_HOURS_FIELD);
        map.put("UpfrontFee", UPFRONT_FEE_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("Tenancy", TENANCY_FIELD);
        map.put("ZoneType", ZONE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityBlockExtensionOffering, T> g) {
        return obj -> g.apply((CapacityBlockExtensionOffering)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityBlockExtensionOfferingId;
        private String instanceType;
        private Integer instanceCount;
        private String availabilityZone;
        private String availabilityZoneId;
        private Instant startDate;
        private Instant capacityBlockExtensionStartDate;
        private Instant capacityBlockExtensionEndDate;
        private Integer capacityBlockExtensionDurationHours;
        private String upfrontFee;
        private String currencyCode;
        private String tenancy;
        private String zoneType;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityBlockExtensionOffering model) {
            this.capacityBlockExtensionOfferingId(model.capacityBlockExtensionOfferingId);
            this.instanceType(model.instanceType);
            this.instanceCount(model.instanceCount);
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.startDate(model.startDate);
            this.capacityBlockExtensionStartDate(model.capacityBlockExtensionStartDate);
            this.capacityBlockExtensionEndDate(model.capacityBlockExtensionEndDate);
            this.capacityBlockExtensionDurationHours(model.capacityBlockExtensionDurationHours);
            this.upfrontFee(model.upfrontFee);
            this.currencyCode(model.currencyCode);
            this.tenancy(model.tenancy);
            this.zoneType(model.zoneType);
        }

        public final String getCapacityBlockExtensionOfferingId() {
            return this.capacityBlockExtensionOfferingId;
        }

        public final void setCapacityBlockExtensionOfferingId(String capacityBlockExtensionOfferingId) {
            this.capacityBlockExtensionOfferingId = capacityBlockExtensionOfferingId;
        }

        @Override
        public final Builder capacityBlockExtensionOfferingId(String capacityBlockExtensionOfferingId) {
            this.capacityBlockExtensionOfferingId = capacityBlockExtensionOfferingId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getCapacityBlockExtensionStartDate() {
            return this.capacityBlockExtensionStartDate;
        }

        public final void setCapacityBlockExtensionStartDate(Instant capacityBlockExtensionStartDate) {
            this.capacityBlockExtensionStartDate = capacityBlockExtensionStartDate;
        }

        @Override
        public final Builder capacityBlockExtensionStartDate(Instant capacityBlockExtensionStartDate) {
            this.capacityBlockExtensionStartDate = capacityBlockExtensionStartDate;
            return this;
        }

        public final Instant getCapacityBlockExtensionEndDate() {
            return this.capacityBlockExtensionEndDate;
        }

        public final void setCapacityBlockExtensionEndDate(Instant capacityBlockExtensionEndDate) {
            this.capacityBlockExtensionEndDate = capacityBlockExtensionEndDate;
        }

        @Override
        public final Builder capacityBlockExtensionEndDate(Instant capacityBlockExtensionEndDate) {
            this.capacityBlockExtensionEndDate = capacityBlockExtensionEndDate;
            return this;
        }

        public final Integer getCapacityBlockExtensionDurationHours() {
            return this.capacityBlockExtensionDurationHours;
        }

        public final void setCapacityBlockExtensionDurationHours(Integer capacityBlockExtensionDurationHours) {
            this.capacityBlockExtensionDurationHours = capacityBlockExtensionDurationHours;
        }

        @Override
        public final Builder capacityBlockExtensionDurationHours(Integer capacityBlockExtensionDurationHours) {
            this.capacityBlockExtensionDurationHours = capacityBlockExtensionDurationHours;
            return this;
        }

        public final String getUpfrontFee() {
            return this.upfrontFee;
        }

        public final void setUpfrontFee(String upfrontFee) {
            this.upfrontFee = upfrontFee;
        }

        @Override
        public final Builder upfrontFee(String upfrontFee) {
            this.upfrontFee = upfrontFee;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(CapacityReservationTenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final String getZoneType() {
            return this.zoneType;
        }

        public final void setZoneType(String zoneType) {
            this.zoneType = zoneType;
        }

        @Override
        public final Builder zoneType(String zoneType) {
            this.zoneType = zoneType;
            return this;
        }

        public CapacityBlockExtensionOffering build() {
            return new CapacityBlockExtensionOffering(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityBlockExtensionOffering> {
        public Builder capacityBlockExtensionOfferingId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceCount(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder startDate(Instant var1);

        public Builder capacityBlockExtensionStartDate(Instant var1);

        public Builder capacityBlockExtensionEndDate(Instant var1);

        public Builder capacityBlockExtensionDurationHours(Integer var1);

        public Builder upfrontFee(String var1);

        public Builder currencyCode(String var1);

        public Builder tenancy(String var1);

        public Builder tenancy(CapacityReservationTenancy var1);

        public Builder zoneType(String var1);
    }
}

