/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesResponse;
import software.amazon.awssdk.services.ec2.model.SecurityGroupRule;

public class DescribeSecurityGroupRulesPublisher
implements SdkPublisher<DescribeSecurityGroupRulesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeSecurityGroupRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSecurityGroupRulesPublisher(Ec2AsyncClient client, DescribeSecurityGroupRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSecurityGroupRulesPublisher(Ec2AsyncClient client, DescribeSecurityGroupRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSecurityGroupRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSecurityGroupRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecurityGroupRule> securityGroupRules() {
        return this.flatMapIterable(response -> response.securityGroupRules());
    }

    private class DescribeSecurityGroupRulesResponseFetcher
    implements AsyncPageFetcher<DescribeSecurityGroupRulesResponse> {
        private DescribeSecurityGroupRulesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSecurityGroupRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSecurityGroupRulesResponse> nextPage(DescribeSecurityGroupRulesResponse previousPage) {
            if (previousPage == null) {
                return DescribeSecurityGroupRulesPublisher.this.client.describeSecurityGroupRules(DescribeSecurityGroupRulesPublisher.this.firstRequest);
            }
            return DescribeSecurityGroupRulesPublisher.this.client.describeSecurityGroupRules((DescribeSecurityGroupRulesRequest)((Object)DescribeSecurityGroupRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

