/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesResponse;
import software.amazon.awssdk.services.ec2.model.MovingAddressStatus;

public class DescribeMovingAddressesPublisher
implements SdkPublisher<DescribeMovingAddressesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeMovingAddressesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMovingAddressesPublisher(Ec2AsyncClient client, DescribeMovingAddressesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMovingAddressesPublisher(Ec2AsyncClient client, DescribeMovingAddressesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMovingAddressesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMovingAddressesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MovingAddressStatus> movingAddressStatuses() {
        return this.flatMapIterable(response -> response.movingAddressStatuses());
    }

    private class DescribeMovingAddressesResponseFetcher
    implements AsyncPageFetcher<DescribeMovingAddressesResponse> {
        private DescribeMovingAddressesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMovingAddressesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeMovingAddressesResponse> nextPage(DescribeMovingAddressesResponse previousPage) {
            if (previousPage == null) {
                return DescribeMovingAddressesPublisher.this.client.describeMovingAddresses(DescribeMovingAddressesPublisher.this.firstRequest);
            }
            return DescribeMovingAddressesPublisher.this.client.describeMovingAddresses((DescribeMovingAddressesRequest)((Object)DescribeMovingAddressesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

