/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIpamPrefixListResolverTargetRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateIpamPrefixListResolverTargetRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateIpamPrefixListResolverTargetRequest.getter(CreateIpamPrefixListResolverTargetRequest::dryRun)).setter(CreateIpamPrefixListResolverTargetRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> IPAM_PREFIX_LIST_RESOLVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPrefixListResolverId").getter(CreateIpamPrefixListResolverTargetRequest.getter(CreateIpamPrefixListResolverTargetRequest::ipamPrefixListResolverId)).setter(CreateIpamPrefixListResolverTargetRequest.setter(Builder::ipamPrefixListResolverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverId").unmarshallLocationName("IpamPrefixListResolverId").build()}).build();
    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListId").getter(CreateIpamPrefixListResolverTargetRequest.getter(CreateIpamPrefixListResolverTargetRequest::prefixListId)).setter(CreateIpamPrefixListResolverTargetRequest.setter(Builder::prefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId").unmarshallLocationName("PrefixListId").build()}).build();
    private static final SdkField<String> PREFIX_LIST_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListRegion").getter(CreateIpamPrefixListResolverTargetRequest.getter(CreateIpamPrefixListResolverTargetRequest::prefixListRegion)).setter(CreateIpamPrefixListResolverTargetRequest.setter(Builder::prefixListRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListRegion").unmarshallLocationName("PrefixListRegion").build()}).build();
    private static final SdkField<Long> DESIRED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DesiredVersion").getter(CreateIpamPrefixListResolverTargetRequest.getter(CreateIpamPrefixListResolverTargetRequest::desiredVersion)).setter(CreateIpamPrefixListResolverTargetRequest.setter(Builder::desiredVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredVersion").unmarshallLocationName("DesiredVersion").build()}).build();
    private static final SdkField<Boolean> TRACK_LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TrackLatestVersion").getter(CreateIpamPrefixListResolverTargetRequest.getter(CreateIpamPrefixListResolverTargetRequest::trackLatestVersion)).setter(CreateIpamPrefixListResolverTargetRequest.setter(Builder::trackLatestVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackLatestVersion").unmarshallLocationName("TrackLatestVersion").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateIpamPrefixListResolverTargetRequest.getter(CreateIpamPrefixListResolverTargetRequest::tagSpecifications)).setter(CreateIpamPrefixListResolverTargetRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateIpamPrefixListResolverTargetRequest.getter(CreateIpamPrefixListResolverTargetRequest::clientToken)).setter(CreateIpamPrefixListResolverTargetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_PREFIX_LIST_RESOLVER_ID_FIELD, PREFIX_LIST_ID_FIELD, PREFIX_LIST_REGION_FIELD, DESIRED_VERSION_FIELD, TRACK_LATEST_VERSION_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIpamPrefixListResolverTargetRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final String ipamPrefixListResolverId;
    private final String prefixListId;
    private final String prefixListRegion;
    private final Long desiredVersion;
    private final Boolean trackLatestVersion;
    private final List<TagSpecification> tagSpecifications;
    private final String clientToken;

    private CreateIpamPrefixListResolverTargetRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamPrefixListResolverId = builder.ipamPrefixListResolverId;
        this.prefixListId = builder.prefixListId;
        this.prefixListRegion = builder.prefixListRegion;
        this.desiredVersion = builder.desiredVersion;
        this.trackLatestVersion = builder.trackLatestVersion;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String ipamPrefixListResolverId() {
        return this.ipamPrefixListResolverId;
    }

    public final String prefixListId() {
        return this.prefixListId;
    }

    public final String prefixListRegion() {
        return this.prefixListRegion;
    }

    public final Long desiredVersion() {
        return this.desiredVersion;
    }

    public final Boolean trackLatestVersion() {
        return this.trackLatestVersion;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPrefixListResolverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackLatestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamPrefixListResolverTargetRequest)) {
            return false;
        }
        CreateIpamPrefixListResolverTargetRequest other = (CreateIpamPrefixListResolverTargetRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.ipamPrefixListResolverId(), other.ipamPrefixListResolverId()) && Objects.equals(this.prefixListId(), other.prefixListId()) && Objects.equals(this.prefixListRegion(), other.prefixListRegion()) && Objects.equals(this.desiredVersion(), other.desiredVersion()) && Objects.equals(this.trackLatestVersion(), other.trackLatestVersion()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIpamPrefixListResolverTargetRequest").add("DryRun", (Object)this.dryRun()).add("IpamPrefixListResolverId", (Object)this.ipamPrefixListResolverId()).add("PrefixListId", (Object)this.prefixListId()).add("PrefixListRegion", (Object)this.prefixListRegion()).add("DesiredVersion", (Object)this.desiredVersion()).add("TrackLatestVersion", (Object)this.trackLatestVersion()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "IpamPrefixListResolverId": {
                return Optional.ofNullable(clazz.cast(this.ipamPrefixListResolverId()));
            }
            case "PrefixListId": {
                return Optional.ofNullable(clazz.cast(this.prefixListId()));
            }
            case "PrefixListRegion": {
                return Optional.ofNullable(clazz.cast(this.prefixListRegion()));
            }
            case "DesiredVersion": {
                return Optional.ofNullable(clazz.cast(this.desiredVersion()));
            }
            case "TrackLatestVersion": {
                return Optional.ofNullable(clazz.cast(this.trackLatestVersion()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamPrefixListResolverId", IPAM_PREFIX_LIST_RESOLVER_ID_FIELD);
        map.put("PrefixListId", PREFIX_LIST_ID_FIELD);
        map.put("PrefixListRegion", PREFIX_LIST_REGION_FIELD);
        map.put("DesiredVersion", DESIRED_VERSION_FIELD);
        map.put("TrackLatestVersion", TRACK_LATEST_VERSION_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIpamPrefixListResolverTargetRequest, T> g) {
        return obj -> g.apply((CreateIpamPrefixListResolverTargetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String ipamPrefixListResolverId;
        private String prefixListId;
        private String prefixListRegion;
        private Long desiredVersion;
        private Boolean trackLatestVersion;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpamPrefixListResolverTargetRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.ipamPrefixListResolverId(model.ipamPrefixListResolverId);
            this.prefixListId(model.prefixListId);
            this.prefixListRegion(model.prefixListRegion);
            this.desiredVersion(model.desiredVersion);
            this.trackLatestVersion(model.trackLatestVersion);
            this.tagSpecifications(model.tagSpecifications);
            this.clientToken(model.clientToken);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamPrefixListResolverId() {
            return this.ipamPrefixListResolverId;
        }

        public final void setIpamPrefixListResolverId(String ipamPrefixListResolverId) {
            this.ipamPrefixListResolverId = ipamPrefixListResolverId;
        }

        @Override
        public final Builder ipamPrefixListResolverId(String ipamPrefixListResolverId) {
            this.ipamPrefixListResolverId = ipamPrefixListResolverId;
            return this;
        }

        public final String getPrefixListId() {
            return this.prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getPrefixListRegion() {
            return this.prefixListRegion;
        }

        public final void setPrefixListRegion(String prefixListRegion) {
            this.prefixListRegion = prefixListRegion;
        }

        @Override
        public final Builder prefixListRegion(String prefixListRegion) {
            this.prefixListRegion = prefixListRegion;
            return this;
        }

        public final Long getDesiredVersion() {
            return this.desiredVersion;
        }

        public final void setDesiredVersion(Long desiredVersion) {
            this.desiredVersion = desiredVersion;
        }

        @Override
        public final Builder desiredVersion(Long desiredVersion) {
            this.desiredVersion = desiredVersion;
            return this;
        }

        public final Boolean getTrackLatestVersion() {
            return this.trackLatestVersion;
        }

        public final void setTrackLatestVersion(Boolean trackLatestVersion) {
            this.trackLatestVersion = trackLatestVersion;
        }

        @Override
        public final Builder trackLatestVersion(Boolean trackLatestVersion) {
            this.trackLatestVersion = trackLatestVersion;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIpamPrefixListResolverTargetRequest build() {
            return new CreateIpamPrefixListResolverTargetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIpamPrefixListResolverTargetRequest> {
        public Builder dryRun(Boolean var1);

        public Builder ipamPrefixListResolverId(String var1);

        public Builder prefixListId(String var1);

        public Builder prefixListRegion(String var1);

        public Builder desiredVersion(Long var1);

        public Builder trackLatestVersion(Boolean var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

