/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityReservationGroup;
import software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationResponse;

public class GetGroupsForCapacityReservationPublisher
implements SdkPublisher<GetGroupsForCapacityReservationResponse> {
    private final Ec2AsyncClient client;
    private final GetGroupsForCapacityReservationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetGroupsForCapacityReservationPublisher(Ec2AsyncClient client, GetGroupsForCapacityReservationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetGroupsForCapacityReservationPublisher(Ec2AsyncClient client, GetGroupsForCapacityReservationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetGroupsForCapacityReservationResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetGroupsForCapacityReservationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CapacityReservationGroup> capacityReservationGroups() {
        return this.flatMapIterable(response -> response.capacityReservationGroups());
    }

    private class GetGroupsForCapacityReservationResponseFetcher
    implements AsyncPageFetcher<GetGroupsForCapacityReservationResponse> {
        private GetGroupsForCapacityReservationResponseFetcher() {
        }

        public boolean hasNextPage(GetGroupsForCapacityReservationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetGroupsForCapacityReservationResponse> nextPage(GetGroupsForCapacityReservationResponse previousPage) {
            if (previousPage == null) {
                return GetGroupsForCapacityReservationPublisher.this.client.getGroupsForCapacityReservation(GetGroupsForCapacityReservationPublisher.this.firstRequest);
            }
            return GetGroupsForCapacityReservationPublisher.this.client.getGroupsForCapacityReservation((GetGroupsForCapacityReservationRequest)((Object)GetGroupsForCapacityReservationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

