/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsResponse;
import software.amazon.awssdk.services.ec2.model.InstanceCreditSpecification;

public class DescribeInstanceCreditSpecificationsPublisher
implements SdkPublisher<DescribeInstanceCreditSpecificationsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeInstanceCreditSpecificationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstanceCreditSpecificationsPublisher(Ec2AsyncClient client, DescribeInstanceCreditSpecificationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstanceCreditSpecificationsPublisher(Ec2AsyncClient client, DescribeInstanceCreditSpecificationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstanceCreditSpecificationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstanceCreditSpecificationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceCreditSpecification> instanceCreditSpecifications() {
        return this.flatMapIterable(response -> response.instanceCreditSpecifications());
    }

    private class DescribeInstanceCreditSpecificationsResponseFetcher
    implements AsyncPageFetcher<DescribeInstanceCreditSpecificationsResponse> {
        private DescribeInstanceCreditSpecificationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceCreditSpecificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInstanceCreditSpecificationsResponse> nextPage(DescribeInstanceCreditSpecificationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceCreditSpecificationsPublisher.this.client.describeInstanceCreditSpecifications(DescribeInstanceCreditSpecificationsPublisher.this.firstRequest);
            }
            return DescribeInstanceCreditSpecificationsPublisher.this.client.describeInstanceCreditSpecifications((DescribeInstanceCreditSpecificationsRequest)((Object)DescribeInstanceCreditSpecificationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

