/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServerPeersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServerPeersResponse;
import software.amazon.awssdk.services.ec2.model.RouteServerPeer;

public class DescribeRouteServerPeersPublisher
implements SdkPublisher<DescribeRouteServerPeersResponse> {
    private final Ec2AsyncClient client;
    private final DescribeRouteServerPeersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRouteServerPeersPublisher(Ec2AsyncClient client, DescribeRouteServerPeersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRouteServerPeersPublisher(Ec2AsyncClient client, DescribeRouteServerPeersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRouteServerPeersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRouteServerPeersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RouteServerPeer> routeServerPeers() {
        return this.flatMapIterable(response -> response.routeServerPeers());
    }

    private class DescribeRouteServerPeersResponseFetcher
    implements AsyncPageFetcher<DescribeRouteServerPeersResponse> {
        private DescribeRouteServerPeersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRouteServerPeersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRouteServerPeersResponse> nextPage(DescribeRouteServerPeersResponse previousPage) {
            if (previousPage == null) {
                return DescribeRouteServerPeersPublisher.this.client.describeRouteServerPeers(DescribeRouteServerPeersPublisher.this.firstRequest);
            }
            return DescribeRouteServerPeersPublisher.this.client.describeRouteServerPeers((DescribeRouteServerPeersRequest)((Object)DescribeRouteServerPeersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

