/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociation;

public class DescribeIpamResourceDiscoveryAssociationsPublisher
implements SdkPublisher<DescribeIpamResourceDiscoveryAssociationsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeIpamResourceDiscoveryAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeIpamResourceDiscoveryAssociationsPublisher(Ec2AsyncClient client, DescribeIpamResourceDiscoveryAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeIpamResourceDiscoveryAssociationsPublisher(Ec2AsyncClient client, DescribeIpamResourceDiscoveryAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeIpamResourceDiscoveryAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeIpamResourceDiscoveryAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IpamResourceDiscoveryAssociation> ipamResourceDiscoveryAssociations() {
        return this.flatMapIterable(response -> response.ipamResourceDiscoveryAssociations());
    }

    private class DescribeIpamResourceDiscoveryAssociationsResponseFetcher
    implements AsyncPageFetcher<DescribeIpamResourceDiscoveryAssociationsResponse> {
        private DescribeIpamResourceDiscoveryAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIpamResourceDiscoveryAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeIpamResourceDiscoveryAssociationsResponse> nextPage(DescribeIpamResourceDiscoveryAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeIpamResourceDiscoveryAssociationsPublisher.this.client.describeIpamResourceDiscoveryAssociations(DescribeIpamResourceDiscoveryAssociationsPublisher.this.firstRequest);
            }
            return DescribeIpamResourceDiscoveryAssociationsPublisher.this.client.describeIpamResourceDiscoveryAssociations((DescribeIpamResourceDiscoveryAssociationsRequest)((Object)DescribeIpamResourceDiscoveryAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

