/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyTransitGatewayMeteringPolicyRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyTransitGatewayMeteringPolicyRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_METERING_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayMeteringPolicyId").getter(ModifyTransitGatewayMeteringPolicyRequest.getter(ModifyTransitGatewayMeteringPolicyRequest::transitGatewayMeteringPolicyId)).setter(ModifyTransitGatewayMeteringPolicyRequest.setter(Builder::transitGatewayMeteringPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMeteringPolicyId").unmarshallLocationName("TransitGatewayMeteringPolicyId").build()}).build();
    private static final SdkField<List<String>> ADD_MIDDLEBOX_ATTACHMENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddMiddleboxAttachmentIds").getter(ModifyTransitGatewayMeteringPolicyRequest.getter(ModifyTransitGatewayMeteringPolicyRequest::addMiddleboxAttachmentIds)).setter(ModifyTransitGatewayMeteringPolicyRequest.setter(Builder::addMiddleboxAttachmentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddMiddleboxAttachmentId").unmarshallLocationName("AddMiddleboxAttachmentId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_MIDDLEBOX_ATTACHMENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveMiddleboxAttachmentIds").getter(ModifyTransitGatewayMeteringPolicyRequest.getter(ModifyTransitGatewayMeteringPolicyRequest::removeMiddleboxAttachmentIds)).setter(ModifyTransitGatewayMeteringPolicyRequest.setter(Builder::removeMiddleboxAttachmentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveMiddleboxAttachmentId").unmarshallLocationName("RemoveMiddleboxAttachmentId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyTransitGatewayMeteringPolicyRequest.getter(ModifyTransitGatewayMeteringPolicyRequest::dryRun)).setter(ModifyTransitGatewayMeteringPolicyRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_METERING_POLICY_ID_FIELD, ADD_MIDDLEBOX_ATTACHMENT_IDS_FIELD, REMOVE_MIDDLEBOX_ATTACHMENT_IDS_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyTransitGatewayMeteringPolicyRequest.memberNameToFieldInitializer();
    private final String transitGatewayMeteringPolicyId;
    private final List<String> addMiddleboxAttachmentIds;
    private final List<String> removeMiddleboxAttachmentIds;
    private final Boolean dryRun;

    private ModifyTransitGatewayMeteringPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayMeteringPolicyId = builder.transitGatewayMeteringPolicyId;
        this.addMiddleboxAttachmentIds = builder.addMiddleboxAttachmentIds;
        this.removeMiddleboxAttachmentIds = builder.removeMiddleboxAttachmentIds;
        this.dryRun = builder.dryRun;
    }

    public final String transitGatewayMeteringPolicyId() {
        return this.transitGatewayMeteringPolicyId;
    }

    public final boolean hasAddMiddleboxAttachmentIds() {
        return this.addMiddleboxAttachmentIds != null && !(this.addMiddleboxAttachmentIds instanceof SdkAutoConstructList);
    }

    public final List<String> addMiddleboxAttachmentIds() {
        return this.addMiddleboxAttachmentIds;
    }

    public final boolean hasRemoveMiddleboxAttachmentIds() {
        return this.removeMiddleboxAttachmentIds != null && !(this.removeMiddleboxAttachmentIds instanceof SdkAutoConstructList);
    }

    public final List<String> removeMiddleboxAttachmentIds() {
        return this.removeMiddleboxAttachmentIds;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayMeteringPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddMiddleboxAttachmentIds() ? this.addMiddleboxAttachmentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveMiddleboxAttachmentIds() ? this.removeMiddleboxAttachmentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTransitGatewayMeteringPolicyRequest)) {
            return false;
        }
        ModifyTransitGatewayMeteringPolicyRequest other = (ModifyTransitGatewayMeteringPolicyRequest)((Object)obj);
        return Objects.equals(this.transitGatewayMeteringPolicyId(), other.transitGatewayMeteringPolicyId()) && this.hasAddMiddleboxAttachmentIds() == other.hasAddMiddleboxAttachmentIds() && Objects.equals(this.addMiddleboxAttachmentIds(), other.addMiddleboxAttachmentIds()) && this.hasRemoveMiddleboxAttachmentIds() == other.hasRemoveMiddleboxAttachmentIds() && Objects.equals(this.removeMiddleboxAttachmentIds(), other.removeMiddleboxAttachmentIds()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyTransitGatewayMeteringPolicyRequest").add("TransitGatewayMeteringPolicyId", (Object)this.transitGatewayMeteringPolicyId()).add("AddMiddleboxAttachmentIds", this.hasAddMiddleboxAttachmentIds() ? this.addMiddleboxAttachmentIds() : null).add("RemoveMiddleboxAttachmentIds", this.hasRemoveMiddleboxAttachmentIds() ? this.removeMiddleboxAttachmentIds() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayMeteringPolicyId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayMeteringPolicyId()));
            }
            case "AddMiddleboxAttachmentIds": {
                return Optional.ofNullable(clazz.cast(this.addMiddleboxAttachmentIds()));
            }
            case "RemoveMiddleboxAttachmentIds": {
                return Optional.ofNullable(clazz.cast(this.removeMiddleboxAttachmentIds()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransitGatewayMeteringPolicyId", TRANSIT_GATEWAY_METERING_POLICY_ID_FIELD);
        map.put("AddMiddleboxAttachmentId", ADD_MIDDLEBOX_ATTACHMENT_IDS_FIELD);
        map.put("RemoveMiddleboxAttachmentId", REMOVE_MIDDLEBOX_ATTACHMENT_IDS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyTransitGatewayMeteringPolicyRequest, T> g) {
        return obj -> g.apply((ModifyTransitGatewayMeteringPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String transitGatewayMeteringPolicyId;
        private List<String> addMiddleboxAttachmentIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeMiddleboxAttachmentIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTransitGatewayMeteringPolicyRequest model) {
            super(model);
            this.transitGatewayMeteringPolicyId(model.transitGatewayMeteringPolicyId);
            this.addMiddleboxAttachmentIds(model.addMiddleboxAttachmentIds);
            this.removeMiddleboxAttachmentIds(model.removeMiddleboxAttachmentIds);
            this.dryRun(model.dryRun);
        }

        public final String getTransitGatewayMeteringPolicyId() {
            return this.transitGatewayMeteringPolicyId;
        }

        public final void setTransitGatewayMeteringPolicyId(String transitGatewayMeteringPolicyId) {
            this.transitGatewayMeteringPolicyId = transitGatewayMeteringPolicyId;
        }

        @Override
        public final Builder transitGatewayMeteringPolicyId(String transitGatewayMeteringPolicyId) {
            this.transitGatewayMeteringPolicyId = transitGatewayMeteringPolicyId;
            return this;
        }

        public final Collection<String> getAddMiddleboxAttachmentIds() {
            if (this.addMiddleboxAttachmentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addMiddleboxAttachmentIds;
        }

        public final void setAddMiddleboxAttachmentIds(Collection<String> addMiddleboxAttachmentIds) {
            this.addMiddleboxAttachmentIds = TransitGatewayAttachmentIdStringListCopier.copy(addMiddleboxAttachmentIds);
        }

        @Override
        public final Builder addMiddleboxAttachmentIds(Collection<String> addMiddleboxAttachmentIds) {
            this.addMiddleboxAttachmentIds = TransitGatewayAttachmentIdStringListCopier.copy(addMiddleboxAttachmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addMiddleboxAttachmentIds(String ... addMiddleboxAttachmentIds) {
            this.addMiddleboxAttachmentIds(Arrays.asList(addMiddleboxAttachmentIds));
            return this;
        }

        public final Collection<String> getRemoveMiddleboxAttachmentIds() {
            if (this.removeMiddleboxAttachmentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeMiddleboxAttachmentIds;
        }

        public final void setRemoveMiddleboxAttachmentIds(Collection<String> removeMiddleboxAttachmentIds) {
            this.removeMiddleboxAttachmentIds = TransitGatewayAttachmentIdStringListCopier.copy(removeMiddleboxAttachmentIds);
        }

        @Override
        public final Builder removeMiddleboxAttachmentIds(Collection<String> removeMiddleboxAttachmentIds) {
            this.removeMiddleboxAttachmentIds = TransitGatewayAttachmentIdStringListCopier.copy(removeMiddleboxAttachmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeMiddleboxAttachmentIds(String ... removeMiddleboxAttachmentIds) {
            this.removeMiddleboxAttachmentIds(Arrays.asList(removeMiddleboxAttachmentIds));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTransitGatewayMeteringPolicyRequest build() {
            return new ModifyTransitGatewayMeteringPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyTransitGatewayMeteringPolicyRequest> {
        public Builder transitGatewayMeteringPolicyId(String var1);

        public Builder addMiddleboxAttachmentIds(Collection<String> var1);

        public Builder addMiddleboxAttachmentIds(String ... var1);

        public Builder removeMiddleboxAttachmentIds(Collection<String> var1);

        public Builder removeMiddleboxAttachmentIds(String ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

