/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageAncestryEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageAncestryEntry> {
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(ImageAncestryEntry.getter(ImageAncestryEntry::creationDate)).setter(ImageAncestryEntry.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").unmarshallLocationName("creationDate").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(ImageAncestryEntry.getter(ImageAncestryEntry::imageId)).setter(ImageAncestryEntry.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<String> IMAGE_OWNER_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageOwnerAlias").getter(ImageAncestryEntry.getter(ImageAncestryEntry::imageOwnerAlias)).setter(ImageAncestryEntry.setter(Builder::imageOwnerAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageOwnerAlias").unmarshallLocationName("imageOwnerAlias").build()}).build();
    private static final SdkField<String> SOURCE_IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceImageId").getter(ImageAncestryEntry.getter(ImageAncestryEntry::sourceImageId)).setter(ImageAncestryEntry.setter(Builder::sourceImageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImageId").unmarshallLocationName("sourceImageId").build()}).build();
    private static final SdkField<String> SOURCE_IMAGE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceImageRegion").getter(ImageAncestryEntry.getter(ImageAncestryEntry::sourceImageRegion)).setter(ImageAncestryEntry.setter(Builder::sourceImageRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImageRegion").unmarshallLocationName("sourceImageRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_FIELD, IMAGE_ID_FIELD, IMAGE_OWNER_ALIAS_FIELD, SOURCE_IMAGE_ID_FIELD, SOURCE_IMAGE_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageAncestryEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant creationDate;
    private final String imageId;
    private final String imageOwnerAlias;
    private final String sourceImageId;
    private final String sourceImageRegion;

    private ImageAncestryEntry(BuilderImpl builder) {
        this.creationDate = builder.creationDate;
        this.imageId = builder.imageId;
        this.imageOwnerAlias = builder.imageOwnerAlias;
        this.sourceImageId = builder.sourceImageId;
        this.sourceImageRegion = builder.sourceImageRegion;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String imageOwnerAlias() {
        return this.imageOwnerAlias;
    }

    public final String sourceImageId() {
        return this.sourceImageId;
    }

    public final String sourceImageRegion() {
        return this.sourceImageRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageOwnerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceImageRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageAncestryEntry)) {
            return false;
        }
        ImageAncestryEntry other = (ImageAncestryEntry)obj;
        return Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.imageOwnerAlias(), other.imageOwnerAlias()) && Objects.equals(this.sourceImageId(), other.sourceImageId()) && Objects.equals(this.sourceImageRegion(), other.sourceImageRegion());
    }

    public final String toString() {
        return ToString.builder((String)"ImageAncestryEntry").add("CreationDate", (Object)this.creationDate()).add("ImageId", (Object)this.imageId()).add("ImageOwnerAlias", (Object)this.imageOwnerAlias()).add("SourceImageId", (Object)this.sourceImageId()).add("SourceImageRegion", (Object)this.sourceImageRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "ImageOwnerAlias": {
                return Optional.ofNullable(clazz.cast(this.imageOwnerAlias()));
            }
            case "SourceImageId": {
                return Optional.ofNullable(clazz.cast(this.sourceImageId()));
            }
            case "SourceImageRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceImageRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("ImageOwnerAlias", IMAGE_OWNER_ALIAS_FIELD);
        map.put("SourceImageId", SOURCE_IMAGE_ID_FIELD);
        map.put("SourceImageRegion", SOURCE_IMAGE_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageAncestryEntry, T> g) {
        return obj -> g.apply((ImageAncestryEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationDate;
        private String imageId;
        private String imageOwnerAlias;
        private String sourceImageId;
        private String sourceImageRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageAncestryEntry model) {
            this.creationDate(model.creationDate);
            this.imageId(model.imageId);
            this.imageOwnerAlias(model.imageOwnerAlias);
            this.sourceImageId(model.sourceImageId);
            this.sourceImageRegion(model.sourceImageRegion);
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getImageOwnerAlias() {
            return this.imageOwnerAlias;
        }

        public final void setImageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
        }

        @Override
        public final Builder imageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
            return this;
        }

        public final String getSourceImageId() {
            return this.sourceImageId;
        }

        public final void setSourceImageId(String sourceImageId) {
            this.sourceImageId = sourceImageId;
        }

        @Override
        public final Builder sourceImageId(String sourceImageId) {
            this.sourceImageId = sourceImageId;
            return this;
        }

        public final String getSourceImageRegion() {
            return this.sourceImageRegion;
        }

        public final void setSourceImageRegion(String sourceImageRegion) {
            this.sourceImageRegion = sourceImageRegion;
        }

        @Override
        public final Builder sourceImageRegion(String sourceImageRegion) {
            this.sourceImageRegion = sourceImageRegion;
            return this;
        }

        public ImageAncestryEntry build() {
            return new ImageAncestryEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageAncestryEntry> {
        public Builder creationDate(Instant var1);

        public Builder imageId(String var1);

        public Builder imageOwnerAlias(String var1);

        public Builder sourceImageId(String var1);

        public Builder sourceImageRegion(String var1);
    }
}

