/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceImageMetadataRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceImageMetadataResponse;
import software.amazon.awssdk.services.ec2.model.InstanceImageMetadata;

public class DescribeInstanceImageMetadataPublisher
implements SdkPublisher<DescribeInstanceImageMetadataResponse> {
    private final Ec2AsyncClient client;
    private final DescribeInstanceImageMetadataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstanceImageMetadataPublisher(Ec2AsyncClient client, DescribeInstanceImageMetadataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstanceImageMetadataPublisher(Ec2AsyncClient client, DescribeInstanceImageMetadataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstanceImageMetadataResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstanceImageMetadataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceImageMetadata> instanceImageMetadata() {
        return this.flatMapIterable(response -> response.instanceImageMetadata());
    }

    private class DescribeInstanceImageMetadataResponseFetcher
    implements AsyncPageFetcher<DescribeInstanceImageMetadataResponse> {
        private DescribeInstanceImageMetadataResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceImageMetadataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInstanceImageMetadataResponse> nextPage(DescribeInstanceImageMetadataResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceImageMetadataPublisher.this.client.describeInstanceImageMetadata(DescribeInstanceImageMetadataPublisher.this.firstRequest);
            }
            return DescribeInstanceImageMetadataPublisher.this.client.describeInstanceImageMetadata((DescribeInstanceImageMetadataRequest)((Object)DescribeInstanceImageMetadataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

