/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ec2.model.Image;

public class DescribeImagesPublisher
implements SdkPublisher<DescribeImagesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeImagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeImagesPublisher(Ec2AsyncClient client, DescribeImagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeImagesPublisher(Ec2AsyncClient client, DescribeImagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeImagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeImagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Image> images() {
        return this.flatMapIterable(response -> response.images());
    }

    private class DescribeImagesResponseFetcher
    implements AsyncPageFetcher<DescribeImagesResponse> {
        private DescribeImagesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeImagesResponse> nextPage(DescribeImagesResponse previousPage) {
            if (previousPage == null) {
                return DescribeImagesPublisher.this.client.describeImages(DescribeImagesPublisher.this.firstRequest);
            }
            return DescribeImagesPublisher.this.client.describeImages((DescribeImagesRequest)((Object)DescribeImagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

