/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsResponse;
import software.amazon.awssdk.services.ec2.model.Subscription;

public class DescribeAwsNetworkPerformanceMetricSubscriptionsPublisher
implements SdkPublisher<DescribeAwsNetworkPerformanceMetricSubscriptionsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeAwsNetworkPerformanceMetricSubscriptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAwsNetworkPerformanceMetricSubscriptionsPublisher(Ec2AsyncClient client, DescribeAwsNetworkPerformanceMetricSubscriptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAwsNetworkPerformanceMetricSubscriptionsPublisher(Ec2AsyncClient client, DescribeAwsNetworkPerformanceMetricSubscriptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAwsNetworkPerformanceMetricSubscriptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAwsNetworkPerformanceMetricSubscriptionsResponse> subscriber) {
        subscriber.onSubscribe((org.reactivestreams.Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Subscription> subscriptions() {
        return this.flatMapIterable(response -> response.subscriptions());
    }

    private class DescribeAwsNetworkPerformanceMetricSubscriptionsResponseFetcher
    implements AsyncPageFetcher<DescribeAwsNetworkPerformanceMetricSubscriptionsResponse> {
        private DescribeAwsNetworkPerformanceMetricSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAwsNetworkPerformanceMetricSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAwsNetworkPerformanceMetricSubscriptionsResponse> nextPage(DescribeAwsNetworkPerformanceMetricSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAwsNetworkPerformanceMetricSubscriptionsPublisher.this.client.describeAwsNetworkPerformanceMetricSubscriptions(DescribeAwsNetworkPerformanceMetricSubscriptionsPublisher.this.firstRequest);
            }
            return DescribeAwsNetworkPerformanceMetricSubscriptionsPublisher.this.client.describeAwsNetworkPerformanceMetricSubscriptions((DescribeAwsNetworkPerformanceMetricSubscriptionsRequest)((Object)DescribeAwsNetworkPerformanceMetricSubscriptionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

