/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkCardInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkCardInfo> {
    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NetworkCardIndex").getter(NetworkCardInfo.getter(NetworkCardInfo::networkCardIndex)).setter(NetworkCardInfo.setter(Builder::networkCardIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex").unmarshallLocationName("networkCardIndex").build()}).build();
    private static final SdkField<String> NETWORK_PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkPerformance").getter(NetworkCardInfo.getter(NetworkCardInfo::networkPerformance)).setter(NetworkCardInfo.setter(Builder::networkPerformance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPerformance").unmarshallLocationName("networkPerformance").build()}).build();
    private static final SdkField<Integer> MAXIMUM_NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumNetworkInterfaces").getter(NetworkCardInfo.getter(NetworkCardInfo::maximumNetworkInterfaces)).setter(NetworkCardInfo.setter(Builder::maximumNetworkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumNetworkInterfaces").unmarshallLocationName("maximumNetworkInterfaces").build()}).build();
    private static final SdkField<Integer> ADDITIONAL_FLEXIBLE_NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AdditionalFlexibleNetworkInterfaces").getter(NetworkCardInfo.getter(NetworkCardInfo::additionalFlexibleNetworkInterfaces)).setter(NetworkCardInfo.setter(Builder::additionalFlexibleNetworkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalFlexibleNetworkInterfaces").unmarshallLocationName("additionalFlexibleNetworkInterfaces").build()}).build();
    private static final SdkField<Double> BASELINE_BANDWIDTH_IN_GBPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("BaselineBandwidthInGbps").getter(NetworkCardInfo.getter(NetworkCardInfo::baselineBandwidthInGbps)).setter(NetworkCardInfo.setter(Builder::baselineBandwidthInGbps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineBandwidthInGbps").unmarshallLocationName("baselineBandwidthInGbps").build()}).build();
    private static final SdkField<Double> PEAK_BANDWIDTH_IN_GBPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("PeakBandwidthInGbps").getter(NetworkCardInfo.getter(NetworkCardInfo::peakBandwidthInGbps)).setter(NetworkCardInfo.setter(Builder::peakBandwidthInGbps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeakBandwidthInGbps").unmarshallLocationName("peakBandwidthInGbps").build()}).build();
    private static final SdkField<Integer> DEFAULT_ENA_QUEUE_COUNT_PER_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultEnaQueueCountPerInterface").getter(NetworkCardInfo.getter(NetworkCardInfo::defaultEnaQueueCountPerInterface)).setter(NetworkCardInfo.setter(Builder::defaultEnaQueueCountPerInterface)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultEnaQueueCountPerInterface").unmarshallLocationName("defaultEnaQueueCountPerInterface").build()}).build();
    private static final SdkField<Integer> MAXIMUM_ENA_QUEUE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumEnaQueueCount").getter(NetworkCardInfo.getter(NetworkCardInfo::maximumEnaQueueCount)).setter(NetworkCardInfo.setter(Builder::maximumEnaQueueCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumEnaQueueCount").unmarshallLocationName("maximumEnaQueueCount").build()}).build();
    private static final SdkField<Integer> MAXIMUM_ENA_QUEUE_COUNT_PER_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumEnaQueueCountPerInterface").getter(NetworkCardInfo.getter(NetworkCardInfo::maximumEnaQueueCountPerInterface)).setter(NetworkCardInfo.setter(Builder::maximumEnaQueueCountPerInterface)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumEnaQueueCountPerInterface").unmarshallLocationName("maximumEnaQueueCountPerInterface").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_CARD_INDEX_FIELD, NETWORK_PERFORMANCE_FIELD, MAXIMUM_NETWORK_INTERFACES_FIELD, ADDITIONAL_FLEXIBLE_NETWORK_INTERFACES_FIELD, BASELINE_BANDWIDTH_IN_GBPS_FIELD, PEAK_BANDWIDTH_IN_GBPS_FIELD, DEFAULT_ENA_QUEUE_COUNT_PER_INTERFACE_FIELD, MAXIMUM_ENA_QUEUE_COUNT_FIELD, MAXIMUM_ENA_QUEUE_COUNT_PER_INTERFACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkCardInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer networkCardIndex;
    private final String networkPerformance;
    private final Integer maximumNetworkInterfaces;
    private final Integer additionalFlexibleNetworkInterfaces;
    private final Double baselineBandwidthInGbps;
    private final Double peakBandwidthInGbps;
    private final Integer defaultEnaQueueCountPerInterface;
    private final Integer maximumEnaQueueCount;
    private final Integer maximumEnaQueueCountPerInterface;

    private NetworkCardInfo(BuilderImpl builder) {
        this.networkCardIndex = builder.networkCardIndex;
        this.networkPerformance = builder.networkPerformance;
        this.maximumNetworkInterfaces = builder.maximumNetworkInterfaces;
        this.additionalFlexibleNetworkInterfaces = builder.additionalFlexibleNetworkInterfaces;
        this.baselineBandwidthInGbps = builder.baselineBandwidthInGbps;
        this.peakBandwidthInGbps = builder.peakBandwidthInGbps;
        this.defaultEnaQueueCountPerInterface = builder.defaultEnaQueueCountPerInterface;
        this.maximumEnaQueueCount = builder.maximumEnaQueueCount;
        this.maximumEnaQueueCountPerInterface = builder.maximumEnaQueueCountPerInterface;
    }

    public final Integer networkCardIndex() {
        return this.networkCardIndex;
    }

    public final String networkPerformance() {
        return this.networkPerformance;
    }

    public final Integer maximumNetworkInterfaces() {
        return this.maximumNetworkInterfaces;
    }

    public final Integer additionalFlexibleNetworkInterfaces() {
        return this.additionalFlexibleNetworkInterfaces;
    }

    public final Double baselineBandwidthInGbps() {
        return this.baselineBandwidthInGbps;
    }

    public final Double peakBandwidthInGbps() {
        return this.peakBandwidthInGbps;
    }

    public final Integer defaultEnaQueueCountPerInterface() {
        return this.defaultEnaQueueCountPerInterface;
    }

    public final Integer maximumEnaQueueCount() {
        return this.maximumEnaQueueCount;
    }

    public final Integer maximumEnaQueueCountPerInterface() {
        return this.maximumEnaQueueCountPerInterface;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkPerformance());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumNetworkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalFlexibleNetworkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineBandwidthInGbps());
        hashCode = 31 * hashCode + Objects.hashCode(this.peakBandwidthInGbps());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultEnaQueueCountPerInterface());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumEnaQueueCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumEnaQueueCountPerInterface());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkCardInfo)) {
            return false;
        }
        NetworkCardInfo other = (NetworkCardInfo)obj;
        return Objects.equals(this.networkCardIndex(), other.networkCardIndex()) && Objects.equals(this.networkPerformance(), other.networkPerformance()) && Objects.equals(this.maximumNetworkInterfaces(), other.maximumNetworkInterfaces()) && Objects.equals(this.additionalFlexibleNetworkInterfaces(), other.additionalFlexibleNetworkInterfaces()) && Objects.equals(this.baselineBandwidthInGbps(), other.baselineBandwidthInGbps()) && Objects.equals(this.peakBandwidthInGbps(), other.peakBandwidthInGbps()) && Objects.equals(this.defaultEnaQueueCountPerInterface(), other.defaultEnaQueueCountPerInterface()) && Objects.equals(this.maximumEnaQueueCount(), other.maximumEnaQueueCount()) && Objects.equals(this.maximumEnaQueueCountPerInterface(), other.maximumEnaQueueCountPerInterface());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkCardInfo").add("NetworkCardIndex", (Object)this.networkCardIndex()).add("NetworkPerformance", (Object)this.networkPerformance()).add("MaximumNetworkInterfaces", (Object)this.maximumNetworkInterfaces()).add("AdditionalFlexibleNetworkInterfaces", (Object)this.additionalFlexibleNetworkInterfaces()).add("BaselineBandwidthInGbps", (Object)this.baselineBandwidthInGbps()).add("PeakBandwidthInGbps", (Object)this.peakBandwidthInGbps()).add("DefaultEnaQueueCountPerInterface", (Object)this.defaultEnaQueueCountPerInterface()).add("MaximumEnaQueueCount", (Object)this.maximumEnaQueueCount()).add("MaximumEnaQueueCountPerInterface", (Object)this.maximumEnaQueueCountPerInterface()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkCardIndex": {
                return Optional.ofNullable(clazz.cast(this.networkCardIndex()));
            }
            case "NetworkPerformance": {
                return Optional.ofNullable(clazz.cast(this.networkPerformance()));
            }
            case "MaximumNetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.maximumNetworkInterfaces()));
            }
            case "AdditionalFlexibleNetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.additionalFlexibleNetworkInterfaces()));
            }
            case "BaselineBandwidthInGbps": {
                return Optional.ofNullable(clazz.cast(this.baselineBandwidthInGbps()));
            }
            case "PeakBandwidthInGbps": {
                return Optional.ofNullable(clazz.cast(this.peakBandwidthInGbps()));
            }
            case "DefaultEnaQueueCountPerInterface": {
                return Optional.ofNullable(clazz.cast(this.defaultEnaQueueCountPerInterface()));
            }
            case "MaximumEnaQueueCount": {
                return Optional.ofNullable(clazz.cast(this.maximumEnaQueueCount()));
            }
            case "MaximumEnaQueueCountPerInterface": {
                return Optional.ofNullable(clazz.cast(this.maximumEnaQueueCountPerInterface()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NetworkCardIndex", NETWORK_CARD_INDEX_FIELD);
        map.put("NetworkPerformance", NETWORK_PERFORMANCE_FIELD);
        map.put("MaximumNetworkInterfaces", MAXIMUM_NETWORK_INTERFACES_FIELD);
        map.put("AdditionalFlexibleNetworkInterfaces", ADDITIONAL_FLEXIBLE_NETWORK_INTERFACES_FIELD);
        map.put("BaselineBandwidthInGbps", BASELINE_BANDWIDTH_IN_GBPS_FIELD);
        map.put("PeakBandwidthInGbps", PEAK_BANDWIDTH_IN_GBPS_FIELD);
        map.put("DefaultEnaQueueCountPerInterface", DEFAULT_ENA_QUEUE_COUNT_PER_INTERFACE_FIELD);
        map.put("MaximumEnaQueueCount", MAXIMUM_ENA_QUEUE_COUNT_FIELD);
        map.put("MaximumEnaQueueCountPerInterface", MAXIMUM_ENA_QUEUE_COUNT_PER_INTERFACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkCardInfo, T> g) {
        return obj -> g.apply((NetworkCardInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer networkCardIndex;
        private String networkPerformance;
        private Integer maximumNetworkInterfaces;
        private Integer additionalFlexibleNetworkInterfaces;
        private Double baselineBandwidthInGbps;
        private Double peakBandwidthInGbps;
        private Integer defaultEnaQueueCountPerInterface;
        private Integer maximumEnaQueueCount;
        private Integer maximumEnaQueueCountPerInterface;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkCardInfo model) {
            this.networkCardIndex(model.networkCardIndex);
            this.networkPerformance(model.networkPerformance);
            this.maximumNetworkInterfaces(model.maximumNetworkInterfaces);
            this.additionalFlexibleNetworkInterfaces(model.additionalFlexibleNetworkInterfaces);
            this.baselineBandwidthInGbps(model.baselineBandwidthInGbps);
            this.peakBandwidthInGbps(model.peakBandwidthInGbps);
            this.defaultEnaQueueCountPerInterface(model.defaultEnaQueueCountPerInterface);
            this.maximumEnaQueueCount(model.maximumEnaQueueCount);
            this.maximumEnaQueueCountPerInterface(model.maximumEnaQueueCountPerInterface);
        }

        public final Integer getNetworkCardIndex() {
            return this.networkCardIndex;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public final String getNetworkPerformance() {
            return this.networkPerformance;
        }

        public final void setNetworkPerformance(String networkPerformance) {
            this.networkPerformance = networkPerformance;
        }

        @Override
        public final Builder networkPerformance(String networkPerformance) {
            this.networkPerformance = networkPerformance;
            return this;
        }

        public final Integer getMaximumNetworkInterfaces() {
            return this.maximumNetworkInterfaces;
        }

        public final void setMaximumNetworkInterfaces(Integer maximumNetworkInterfaces) {
            this.maximumNetworkInterfaces = maximumNetworkInterfaces;
        }

        @Override
        public final Builder maximumNetworkInterfaces(Integer maximumNetworkInterfaces) {
            this.maximumNetworkInterfaces = maximumNetworkInterfaces;
            return this;
        }

        public final Integer getAdditionalFlexibleNetworkInterfaces() {
            return this.additionalFlexibleNetworkInterfaces;
        }

        public final void setAdditionalFlexibleNetworkInterfaces(Integer additionalFlexibleNetworkInterfaces) {
            this.additionalFlexibleNetworkInterfaces = additionalFlexibleNetworkInterfaces;
        }

        @Override
        public final Builder additionalFlexibleNetworkInterfaces(Integer additionalFlexibleNetworkInterfaces) {
            this.additionalFlexibleNetworkInterfaces = additionalFlexibleNetworkInterfaces;
            return this;
        }

        public final Double getBaselineBandwidthInGbps() {
            return this.baselineBandwidthInGbps;
        }

        public final void setBaselineBandwidthInGbps(Double baselineBandwidthInGbps) {
            this.baselineBandwidthInGbps = baselineBandwidthInGbps;
        }

        @Override
        public final Builder baselineBandwidthInGbps(Double baselineBandwidthInGbps) {
            this.baselineBandwidthInGbps = baselineBandwidthInGbps;
            return this;
        }

        public final Double getPeakBandwidthInGbps() {
            return this.peakBandwidthInGbps;
        }

        public final void setPeakBandwidthInGbps(Double peakBandwidthInGbps) {
            this.peakBandwidthInGbps = peakBandwidthInGbps;
        }

        @Override
        public final Builder peakBandwidthInGbps(Double peakBandwidthInGbps) {
            this.peakBandwidthInGbps = peakBandwidthInGbps;
            return this;
        }

        public final Integer getDefaultEnaQueueCountPerInterface() {
            return this.defaultEnaQueueCountPerInterface;
        }

        public final void setDefaultEnaQueueCountPerInterface(Integer defaultEnaQueueCountPerInterface) {
            this.defaultEnaQueueCountPerInterface = defaultEnaQueueCountPerInterface;
        }

        @Override
        public final Builder defaultEnaQueueCountPerInterface(Integer defaultEnaQueueCountPerInterface) {
            this.defaultEnaQueueCountPerInterface = defaultEnaQueueCountPerInterface;
            return this;
        }

        public final Integer getMaximumEnaQueueCount() {
            return this.maximumEnaQueueCount;
        }

        public final void setMaximumEnaQueueCount(Integer maximumEnaQueueCount) {
            this.maximumEnaQueueCount = maximumEnaQueueCount;
        }

        @Override
        public final Builder maximumEnaQueueCount(Integer maximumEnaQueueCount) {
            this.maximumEnaQueueCount = maximumEnaQueueCount;
            return this;
        }

        public final Integer getMaximumEnaQueueCountPerInterface() {
            return this.maximumEnaQueueCountPerInterface;
        }

        public final void setMaximumEnaQueueCountPerInterface(Integer maximumEnaQueueCountPerInterface) {
            this.maximumEnaQueueCountPerInterface = maximumEnaQueueCountPerInterface;
        }

        @Override
        public final Builder maximumEnaQueueCountPerInterface(Integer maximumEnaQueueCountPerInterface) {
            this.maximumEnaQueueCountPerInterface = maximumEnaQueueCountPerInterface;
            return this;
        }

        public NetworkCardInfo build() {
            return new NetworkCardInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkCardInfo> {
        public Builder networkCardIndex(Integer var1);

        public Builder networkPerformance(String var1);

        public Builder maximumNetworkInterfaces(Integer var1);

        public Builder additionalFlexibleNetworkInterfaces(Integer var1);

        public Builder baselineBandwidthInGbps(Double var1);

        public Builder peakBandwidthInGbps(Double var1);

        public Builder defaultEnaQueueCountPerInterface(Integer var1);

        public Builder maximumEnaQueueCount(Integer var1);

        public Builder maximumEnaQueueCountPerInterface(Integer var1);
    }
}

