/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.UserTrustProviderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifiedAccessInstanceUserTrustProviderClientConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VerifiedAccessInstanceUserTrustProviderClientConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::typeAsString)).setter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<String> SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scopes").getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::scopes)).setter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.setter(Builder::scopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scopes").unmarshallLocationName("scopes").build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Issuer").getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::issuer)).setter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").unmarshallLocationName("issuer").build()}).build();
    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorizationEndpoint").getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::authorizationEndpoint)).setter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.setter(Builder::authorizationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationEndpoint").unmarshallLocationName("authorizationEndpoint").build()}).build();
    private static final SdkField<String> PUBLIC_SIGNING_KEY_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicSigningKeyEndpoint").getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::publicSigningKeyEndpoint)).setter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.setter(Builder::publicSigningKeyEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicSigningKeyEndpoint").unmarshallLocationName("publicSigningKeyEndpoint").build()}).build();
    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TokenEndpoint").getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::tokenEndpoint)).setter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.setter(Builder::tokenEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenEndpoint").unmarshallLocationName("tokenEndpoint").build()}).build();
    private static final SdkField<String> USER_INFO_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserInfoEndpoint").getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::userInfoEndpoint)).setter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.setter(Builder::userInfoEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInfoEndpoint").unmarshallLocationName("userInfoEndpoint").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::clientId)).setter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").unmarshallLocationName("clientId").build()}).build();
    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientSecret").getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::clientSecret)).setter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.setter(Builder::clientSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSecret").unmarshallLocationName("clientSecret").build()}).build();
    private static final SdkField<Boolean> PKCE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PkceEnabled").getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.getter(VerifiedAccessInstanceUserTrustProviderClientConfiguration::pkceEnabled)).setter(VerifiedAccessInstanceUserTrustProviderClientConfiguration.setter(Builder::pkceEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PkceEnabled").unmarshallLocationName("pkceEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SCOPES_FIELD, ISSUER_FIELD, AUTHORIZATION_ENDPOINT_FIELD, PUBLIC_SIGNING_KEY_ENDPOINT_FIELD, TOKEN_ENDPOINT_FIELD, USER_INFO_ENDPOINT_FIELD, CLIENT_ID_FIELD, CLIENT_SECRET_FIELD, PKCE_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VerifiedAccessInstanceUserTrustProviderClientConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String scopes;
    private final String issuer;
    private final String authorizationEndpoint;
    private final String publicSigningKeyEndpoint;
    private final String tokenEndpoint;
    private final String userInfoEndpoint;
    private final String clientId;
    private final String clientSecret;
    private final Boolean pkceEnabled;

    private VerifiedAccessInstanceUserTrustProviderClientConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.scopes = builder.scopes;
        this.issuer = builder.issuer;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.publicSigningKeyEndpoint = builder.publicSigningKeyEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.userInfoEndpoint = builder.userInfoEndpoint;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.pkceEnabled = builder.pkceEnabled;
    }

    public final UserTrustProviderType type() {
        return UserTrustProviderType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String scopes() {
        return this.scopes;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final String authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public final String publicSigningKeyEndpoint() {
        return this.publicSigningKeyEndpoint;
    }

    public final String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public final String userInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String clientSecret() {
        return this.clientSecret;
    }

    public final Boolean pkceEnabled() {
        return this.pkceEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopes());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicSigningKeyEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.userInfoEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.pkceEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessInstanceUserTrustProviderClientConfiguration)) {
            return false;
        }
        VerifiedAccessInstanceUserTrustProviderClientConfiguration other = (VerifiedAccessInstanceUserTrustProviderClientConfiguration)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.scopes(), other.scopes()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.authorizationEndpoint(), other.authorizationEndpoint()) && Objects.equals(this.publicSigningKeyEndpoint(), other.publicSigningKeyEndpoint()) && Objects.equals(this.tokenEndpoint(), other.tokenEndpoint()) && Objects.equals(this.userInfoEndpoint(), other.userInfoEndpoint()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.clientSecret(), other.clientSecret()) && Objects.equals(this.pkceEnabled(), other.pkceEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"VerifiedAccessInstanceUserTrustProviderClientConfiguration").add("Type", (Object)this.typeAsString()).add("Scopes", (Object)this.scopes()).add("Issuer", (Object)this.issuer()).add("AuthorizationEndpoint", (Object)this.authorizationEndpoint()).add("PublicSigningKeyEndpoint", (Object)this.publicSigningKeyEndpoint()).add("TokenEndpoint", (Object)this.tokenEndpoint()).add("UserInfoEndpoint", (Object)this.userInfoEndpoint()).add("ClientId", (Object)this.clientId()).add("ClientSecret", (Object)(this.clientSecret() == null ? null : "*** Sensitive Data Redacted ***")).add("PkceEnabled", (Object)this.pkceEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Scopes": {
                return Optional.ofNullable(clazz.cast(this.scopes()));
            }
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "AuthorizationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.authorizationEndpoint()));
            }
            case "PublicSigningKeyEndpoint": {
                return Optional.ofNullable(clazz.cast(this.publicSigningKeyEndpoint()));
            }
            case "TokenEndpoint": {
                return Optional.ofNullable(clazz.cast(this.tokenEndpoint()));
            }
            case "UserInfoEndpoint": {
                return Optional.ofNullable(clazz.cast(this.userInfoEndpoint()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "ClientSecret": {
                return Optional.ofNullable(clazz.cast(this.clientSecret()));
            }
            case "PkceEnabled": {
                return Optional.ofNullable(clazz.cast(this.pkceEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("Scopes", SCOPES_FIELD);
        map.put("Issuer", ISSUER_FIELD);
        map.put("AuthorizationEndpoint", AUTHORIZATION_ENDPOINT_FIELD);
        map.put("PublicSigningKeyEndpoint", PUBLIC_SIGNING_KEY_ENDPOINT_FIELD);
        map.put("TokenEndpoint", TOKEN_ENDPOINT_FIELD);
        map.put("UserInfoEndpoint", USER_INFO_ENDPOINT_FIELD);
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("ClientSecret", CLIENT_SECRET_FIELD);
        map.put("PkceEnabled", PKCE_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessInstanceUserTrustProviderClientConfiguration, T> g) {
        return obj -> g.apply((VerifiedAccessInstanceUserTrustProviderClientConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String scopes;
        private String issuer;
        private String authorizationEndpoint;
        private String publicSigningKeyEndpoint;
        private String tokenEndpoint;
        private String userInfoEndpoint;
        private String clientId;
        private String clientSecret;
        private Boolean pkceEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessInstanceUserTrustProviderClientConfiguration model) {
            this.type(model.type);
            this.scopes(model.scopes);
            this.issuer(model.issuer);
            this.authorizationEndpoint(model.authorizationEndpoint);
            this.publicSigningKeyEndpoint(model.publicSigningKeyEndpoint);
            this.tokenEndpoint(model.tokenEndpoint);
            this.userInfoEndpoint(model.userInfoEndpoint);
            this.clientId(model.clientId);
            this.clientSecret(model.clientSecret);
            this.pkceEnabled(model.pkceEnabled);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserTrustProviderType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getScopes() {
            return this.scopes;
        }

        public final void setScopes(String scopes) {
            this.scopes = scopes;
        }

        @Override
        public final Builder scopes(String scopes) {
            this.scopes = scopes;
            return this;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getAuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final String getPublicSigningKeyEndpoint() {
            return this.publicSigningKeyEndpoint;
        }

        public final void setPublicSigningKeyEndpoint(String publicSigningKeyEndpoint) {
            this.publicSigningKeyEndpoint = publicSigningKeyEndpoint;
        }

        @Override
        public final Builder publicSigningKeyEndpoint(String publicSigningKeyEndpoint) {
            this.publicSigningKeyEndpoint = publicSigningKeyEndpoint;
            return this;
        }

        public final String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final String getUserInfoEndpoint() {
            return this.userInfoEndpoint;
        }

        public final void setUserInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
        }

        @Override
        public final Builder userInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return this.clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final Boolean getPkceEnabled() {
            return this.pkceEnabled;
        }

        public final void setPkceEnabled(Boolean pkceEnabled) {
            this.pkceEnabled = pkceEnabled;
        }

        @Override
        public final Builder pkceEnabled(Boolean pkceEnabled) {
            this.pkceEnabled = pkceEnabled;
            return this;
        }

        public VerifiedAccessInstanceUserTrustProviderClientConfiguration build() {
            return new VerifiedAccessInstanceUserTrustProviderClientConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VerifiedAccessInstanceUserTrustProviderClientConfiguration> {
        public Builder type(String var1);

        public Builder type(UserTrustProviderType var1);

        public Builder scopes(String var1);

        public Builder issuer(String var1);

        public Builder authorizationEndpoint(String var1);

        public Builder publicSigningKeyEndpoint(String var1);

        public Builder tokenEndpoint(String var1);

        public Builder userInfoEndpoint(String var1);

        public Builder clientId(String var1);

        public Builder clientSecret(String var1);

        public Builder pkceEnabled(Boolean var1);
    }
}

