/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteSecondaryNetworkRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteSecondaryNetworkRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(DeleteSecondaryNetworkRequest.getter(DeleteSecondaryNetworkRequest::clientToken)).setter(DeleteSecondaryNetworkRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DeleteSecondaryNetworkRequest.getter(DeleteSecondaryNetworkRequest::dryRun)).setter(DeleteSecondaryNetworkRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> SECONDARY_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryNetworkId").getter(DeleteSecondaryNetworkRequest.getter(DeleteSecondaryNetworkRequest::secondaryNetworkId)).setter(DeleteSecondaryNetworkRequest.setter(Builder::secondaryNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryNetworkId").unmarshallLocationName("SecondaryNetworkId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DRY_RUN_FIELD, SECONDARY_NETWORK_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteSecondaryNetworkRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final Boolean dryRun;
    private final String secondaryNetworkId;

    private DeleteSecondaryNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.secondaryNetworkId = builder.secondaryNetworkId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String secondaryNetworkId() {
        return this.secondaryNetworkId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryNetworkId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSecondaryNetworkRequest)) {
            return false;
        }
        DeleteSecondaryNetworkRequest other = (DeleteSecondaryNetworkRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.secondaryNetworkId(), other.secondaryNetworkId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteSecondaryNetworkRequest").add("ClientToken", (Object)this.clientToken()).add("DryRun", (Object)this.dryRun()).add("SecondaryNetworkId", (Object)this.secondaryNetworkId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "SecondaryNetworkId": {
                return Optional.ofNullable(clazz.cast(this.secondaryNetworkId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("SecondaryNetworkId", SECONDARY_NETWORK_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteSecondaryNetworkRequest, T> g) {
        return obj -> g.apply((DeleteSecondaryNetworkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private Boolean dryRun;
        private String secondaryNetworkId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSecondaryNetworkRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.dryRun(model.dryRun);
            this.secondaryNetworkId(model.secondaryNetworkId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getSecondaryNetworkId() {
            return this.secondaryNetworkId;
        }

        public final void setSecondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
        }

        @Override
        public final Builder secondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSecondaryNetworkRequest build() {
            return new DeleteSecondaryNetworkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteSecondaryNetworkRequest> {
        public Builder clientToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder secondaryNetworkId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

