/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.SecondarySubnetCidrBlockAssociationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecondarySubnetIpv4CidrBlockAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecondarySubnetIpv4CidrBlockAssociation> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(SecondarySubnetIpv4CidrBlockAssociation.getter(SecondarySubnetIpv4CidrBlockAssociation::associationId)).setter(SecondarySubnetIpv4CidrBlockAssociation.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").unmarshallLocationName("associationId").build()}).build();
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CidrBlock").getter(SecondarySubnetIpv4CidrBlockAssociation.getter(SecondarySubnetIpv4CidrBlockAssociation::cidrBlock)).setter(SecondarySubnetIpv4CidrBlockAssociation.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").unmarshallLocationName("cidrBlock").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(SecondarySubnetIpv4CidrBlockAssociation.getter(SecondarySubnetIpv4CidrBlockAssociation::stateAsString)).setter(SecondarySubnetIpv4CidrBlockAssociation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(SecondarySubnetIpv4CidrBlockAssociation.getter(SecondarySubnetIpv4CidrBlockAssociation::stateReason)).setter(SecondarySubnetIpv4CidrBlockAssociation.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").unmarshallLocationName("stateReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, CIDR_BLOCK_FIELD, STATE_FIELD, STATE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SecondarySubnetIpv4CidrBlockAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String cidrBlock;
    private final String state;
    private final String stateReason;

    private SecondarySubnetIpv4CidrBlockAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.cidrBlock = builder.cidrBlock;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String cidrBlock() {
        return this.cidrBlock;
    }

    public final SecondarySubnetCidrBlockAssociationState state() {
        return SecondarySubnetCidrBlockAssociationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecondarySubnetIpv4CidrBlockAssociation)) {
            return false;
        }
        SecondarySubnetIpv4CidrBlockAssociation other = (SecondarySubnetIpv4CidrBlockAssociation)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason());
    }

    public final String toString() {
        return ToString.builder((String)"SecondarySubnetIpv4CidrBlockAssociation").add("AssociationId", (Object)this.associationId()).add("CidrBlock", (Object)this.cidrBlock()).add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("CidrBlock", CIDR_BLOCK_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecondarySubnetIpv4CidrBlockAssociation, T> g) {
        return obj -> g.apply((SecondarySubnetIpv4CidrBlockAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String cidrBlock;
        private String state;
        private String stateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(SecondarySubnetIpv4CidrBlockAssociation model) {
            this.associationId(model.associationId);
            this.cidrBlock(model.cidrBlock);
            this.state(model.state);
            this.stateReason(model.stateReason);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SecondarySubnetCidrBlockAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public SecondarySubnetIpv4CidrBlockAssociation build() {
            return new SecondarySubnetIpv4CidrBlockAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecondarySubnetIpv4CidrBlockAssociation> {
        public Builder associationId(String var1);

        public Builder cidrBlock(String var1);

        public Builder state(String var1);

        public Builder state(SecondarySubnetCidrBlockAssociationState var1);

        public Builder stateReason(String var1);
    }
}

