/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AttachmentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecondaryInterfaceAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecondaryInterfaceAttachment> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentId").getter(SecondaryInterfaceAttachment.getter(SecondaryInterfaceAttachment::attachmentId)).setter(SecondaryInterfaceAttachment.setter(Builder::attachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").unmarshallLocationName("attachmentId").build()}).build();
    private static final SdkField<Instant> ATTACH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AttachTime").getter(SecondaryInterfaceAttachment.getter(SecondaryInterfaceAttachment::attachTime)).setter(SecondaryInterfaceAttachment.setter(Builder::attachTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachTime").unmarshallLocationName("attachTime").build()}).build();
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteOnTermination").getter(SecondaryInterfaceAttachment.getter(SecondaryInterfaceAttachment::deleteOnTermination)).setter(SecondaryInterfaceAttachment.setter(Builder::deleteOnTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").unmarshallLocationName("deleteOnTermination").build()}).build();
    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DeviceIndex").getter(SecondaryInterfaceAttachment.getter(SecondaryInterfaceAttachment::deviceIndex)).setter(SecondaryInterfaceAttachment.setter(Builder::deviceIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex").unmarshallLocationName("deviceIndex").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(SecondaryInterfaceAttachment.getter(SecondaryInterfaceAttachment::instanceId)).setter(SecondaryInterfaceAttachment.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> INSTANCE_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceOwnerId").getter(SecondaryInterfaceAttachment.getter(SecondaryInterfaceAttachment::instanceOwnerId)).setter(SecondaryInterfaceAttachment.setter(Builder::instanceOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceOwnerId").unmarshallLocationName("instanceOwnerId").build()}).build();
    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NetworkCardIndex").getter(SecondaryInterfaceAttachment.getter(SecondaryInterfaceAttachment::networkCardIndex)).setter(SecondaryInterfaceAttachment.setter(Builder::networkCardIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex").unmarshallLocationName("networkCardIndex").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SecondaryInterfaceAttachment.getter(SecondaryInterfaceAttachment::statusAsString)).setter(SecondaryInterfaceAttachment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD, ATTACH_TIME_FIELD, DELETE_ON_TERMINATION_FIELD, DEVICE_INDEX_FIELD, INSTANCE_ID_FIELD, INSTANCE_OWNER_ID_FIELD, NETWORK_CARD_INDEX_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SecondaryInterfaceAttachment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attachmentId;
    private final Instant attachTime;
    private final Boolean deleteOnTermination;
    private final Integer deviceIndex;
    private final String instanceId;
    private final String instanceOwnerId;
    private final Integer networkCardIndex;
    private final String status;

    private SecondaryInterfaceAttachment(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.attachTime = builder.attachTime;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.deviceIndex = builder.deviceIndex;
        this.instanceId = builder.instanceId;
        this.instanceOwnerId = builder.instanceOwnerId;
        this.networkCardIndex = builder.networkCardIndex;
        this.status = builder.status;
    }

    public final String attachmentId() {
        return this.attachmentId;
    }

    public final Instant attachTime() {
        return this.attachTime;
    }

    public final Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public final Integer deviceIndex() {
        return this.deviceIndex;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String instanceOwnerId() {
        return this.instanceOwnerId;
    }

    public final Integer networkCardIndex() {
        return this.networkCardIndex;
    }

    public final AttachmentStatus status() {
        return AttachmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecondaryInterfaceAttachment)) {
            return false;
        }
        SecondaryInterfaceAttachment other = (SecondaryInterfaceAttachment)obj;
        return Objects.equals(this.attachmentId(), other.attachmentId()) && Objects.equals(this.attachTime(), other.attachTime()) && Objects.equals(this.deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(this.deviceIndex(), other.deviceIndex()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceOwnerId(), other.instanceOwnerId()) && Objects.equals(this.networkCardIndex(), other.networkCardIndex()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SecondaryInterfaceAttachment").add("AttachmentId", (Object)this.attachmentId()).add("AttachTime", (Object)this.attachTime()).add("DeleteOnTermination", (Object)this.deleteOnTermination()).add("DeviceIndex", (Object)this.deviceIndex()).add("InstanceId", (Object)this.instanceId()).add("InstanceOwnerId", (Object)this.instanceOwnerId()).add("NetworkCardIndex", (Object)this.networkCardIndex()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "AttachTime": {
                return Optional.ofNullable(clazz.cast(this.attachTime()));
            }
            case "DeleteOnTermination": {
                return Optional.ofNullable(clazz.cast(this.deleteOnTermination()));
            }
            case "DeviceIndex": {
                return Optional.ofNullable(clazz.cast(this.deviceIndex()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceOwnerId": {
                return Optional.ofNullable(clazz.cast(this.instanceOwnerId()));
            }
            case "NetworkCardIndex": {
                return Optional.ofNullable(clazz.cast(this.networkCardIndex()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AttachmentId", ATTACHMENT_ID_FIELD);
        map.put("AttachTime", ATTACH_TIME_FIELD);
        map.put("DeleteOnTermination", DELETE_ON_TERMINATION_FIELD);
        map.put("DeviceIndex", DEVICE_INDEX_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("InstanceOwnerId", INSTANCE_OWNER_ID_FIELD);
        map.put("NetworkCardIndex", NETWORK_CARD_INDEX_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecondaryInterfaceAttachment, T> g) {
        return obj -> g.apply((SecondaryInterfaceAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attachmentId;
        private Instant attachTime;
        private Boolean deleteOnTermination;
        private Integer deviceIndex;
        private String instanceId;
        private String instanceOwnerId;
        private Integer networkCardIndex;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SecondaryInterfaceAttachment model) {
            this.attachmentId(model.attachmentId);
            this.attachTime(model.attachTime);
            this.deleteOnTermination(model.deleteOnTermination);
            this.deviceIndex(model.deviceIndex);
            this.instanceId(model.instanceId);
            this.instanceOwnerId(model.instanceOwnerId);
            this.networkCardIndex(model.networkCardIndex);
            this.status(model.status);
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final Instant getAttachTime() {
            return this.attachTime;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final Integer getDeviceIndex() {
            return this.deviceIndex;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceOwnerId() {
            return this.instanceOwnerId;
        }

        public final void setInstanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
        }

        @Override
        public final Builder instanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
            return this;
        }

        public final Integer getNetworkCardIndex() {
            return this.networkCardIndex;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AttachmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public SecondaryInterfaceAttachment build() {
            return new SecondaryInterfaceAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecondaryInterfaceAttachment> {
        public Builder attachmentId(String var1);

        public Builder attachTime(Instant var1);

        public Builder deleteOnTermination(Boolean var1);

        public Builder deviceIndex(Integer var1);

        public Builder instanceId(String var1);

        public Builder instanceOwnerId(String var1);

        public Builder networkCardIndex(Integer var1);

        public Builder status(String var1);

        public Builder status(AttachmentStatus var1);
    }
}

