/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetIpamPrefixListResolverVersionEntriesRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPrefixListResolverVersionEntriesResponse;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverVersionEntry;

public class GetIpamPrefixListResolverVersionEntriesIterable
implements SdkIterable<GetIpamPrefixListResolverVersionEntriesResponse> {
    private final Ec2Client client;
    private final GetIpamPrefixListResolverVersionEntriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetIpamPrefixListResolverVersionEntriesIterable(Ec2Client client, GetIpamPrefixListResolverVersionEntriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetIpamPrefixListResolverVersionEntriesResponseFetcher();
    }

    public Iterator<GetIpamPrefixListResolverVersionEntriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IpamPrefixListResolverVersionEntry> entries() {
        Function<GetIpamPrefixListResolverVersionEntriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.entries() != null) {
                return response.entries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetIpamPrefixListResolverVersionEntriesResponseFetcher
    implements SyncPageFetcher<GetIpamPrefixListResolverVersionEntriesResponse> {
        private GetIpamPrefixListResolverVersionEntriesResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamPrefixListResolverVersionEntriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetIpamPrefixListResolverVersionEntriesResponse nextPage(GetIpamPrefixListResolverVersionEntriesResponse previousPage) {
            if (previousPage == null) {
                return GetIpamPrefixListResolverVersionEntriesIterable.this.client.getIpamPrefixListResolverVersionEntries(GetIpamPrefixListResolverVersionEntriesIterable.this.firstRequest);
            }
            return GetIpamPrefixListResolverVersionEntriesIterable.this.client.getIpamPrefixListResolverVersionEntries((GetIpamPrefixListResolverVersionEntriesRequest)((Object)GetIpamPrefixListResolverVersionEntriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

