/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class SecondaryInterfaceIpv4AddressListCopier {
    static List<SecondaryInterfaceIpv4Address> copy(
            Collection<? extends SecondaryInterfaceIpv4Address> secondaryInterfaceIpv4AddressListParam) {
        List<SecondaryInterfaceIpv4Address> list;
        if (secondaryInterfaceIpv4AddressListParam == null
                || secondaryInterfaceIpv4AddressListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SecondaryInterfaceIpv4Address> modifiableList = new ArrayList<>(secondaryInterfaceIpv4AddressListParam.size());
            secondaryInterfaceIpv4AddressListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SecondaryInterfaceIpv4Address> copyFromBuilder(
            Collection<? extends SecondaryInterfaceIpv4Address.Builder> secondaryInterfaceIpv4AddressListParam) {
        List<SecondaryInterfaceIpv4Address> list;
        if (secondaryInterfaceIpv4AddressListParam == null
                || secondaryInterfaceIpv4AddressListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SecondaryInterfaceIpv4Address> modifiableList = new ArrayList<>(secondaryInterfaceIpv4AddressListParam.size());
            secondaryInterfaceIpv4AddressListParam.forEach(entry -> {
                SecondaryInterfaceIpv4Address member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SecondaryInterfaceIpv4Address.Builder> copyToBuilder(
            Collection<? extends SecondaryInterfaceIpv4Address> secondaryInterfaceIpv4AddressListParam) {
        List<SecondaryInterfaceIpv4Address.Builder> list;
        if (secondaryInterfaceIpv4AddressListParam == null
                || secondaryInterfaceIpv4AddressListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SecondaryInterfaceIpv4Address.Builder> modifiableList = new ArrayList<>(
                    secondaryInterfaceIpv4AddressListParam.size());
            secondaryInterfaceIpv4AddressListParam.forEach(entry -> {
                SecondaryInterfaceIpv4Address.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
